/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.LangLibrary;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaDocumentation;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public abstract class AbstractTypeSymbol
implements TypeSymbol {
    protected final CompilerContext context;
    protected List<FunctionSymbol> langLibFunctions;
    private final TypeDescKind typeDescKind;
    private final ModuleID moduleID;
    private final BType bType;
    private final Documentation docAttachment;

    public AbstractTypeSymbol(CompilerContext context, TypeDescKind typeDescKind, ModuleID moduleID, BType bType) {
        this.context = context;
        this.typeDescKind = typeDescKind;
        this.moduleID = moduleID;
        this.bType = bType;
        this.docAttachment = this.getDocAttachment(bType);
    }

    @Override
    public TypeDescKind typeKind() {
        return this.typeDescKind;
    }

    @Override
    public ModuleID moduleID() {
        return this.moduleID;
    }

    @Override
    public abstract String signature();

    @Override
    public String name() {
        return "";
    }

    @Override
    public SymbolKind kind() {
        return SymbolKind.TYPE;
    }

    @Override
    public Optional<Documentation> docAttachment() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public Location location() {
        return null;
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        if (this.langLibFunctions == null) {
            LangLibrary langLibrary = LangLibrary.getInstance(this.context);
            List<FunctionSymbol> functions = langLibrary.getMethods(this.typeKind());
            this.langLibFunctions = this.filterLangLibMethods(functions, this.getBType());
        }
        return this.langLibFunctions;
    }

    @Override
    public boolean assignableTo(TypeSymbol targetType) {
        Types types = Types.getInstance(this.context);
        return types.isAssignable(this.bType, this.getTargetBType(targetType));
    }

    public BType getBType() {
        return this.bType;
    }

    protected List<FunctionSymbol> filterLangLibMethods(List<FunctionSymbol> functions, BType internalType) {
        Types types = Types.getInstance(this.context);
        ArrayList<FunctionSymbol> filteredFunctions = new ArrayList<FunctionSymbol>();
        for (FunctionSymbol function : functions) {
            ParameterSymbol firstParam = function.typeDescriptor().parameters().get(0);
            BType firstParamType = ((AbstractTypeSymbol)firstParam.typeDescriptor()).getBType();
            if (!types.isAssignable(internalType, firstParamType)) continue;
            filteredFunctions.add(function);
        }
        return filteredFunctions;
    }

    private BType getTargetBType(TypeSymbol typeSymbol) {
        if (typeSymbol.kind() == SymbolKind.TYPE) {
            return ((AbstractTypeSymbol)typeSymbol).getBType();
        }
        return ((BallerinaClassSymbol)typeSymbol).getBType();
    }

    private Documentation getDocAttachment(BType bType) {
        return bType == null || bType.tsymbol == null ? null : new BallerinaDocumentation(bType.tsymbol.markdownDocumentation);
    }
}

