/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.symbols.BallerinaVariableSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;

public class BallerinaConstantSymbol
extends BallerinaVariableSymbol
implements ConstantSymbol {
    private final Object constValue;
    private TypeSymbol broaderType;

    private BallerinaConstantSymbol(String name, PackageID moduleID, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, TypeSymbol typeDescriptor, TypeSymbol broaderType, Object constValue, BSymbol bSymbol) {
        super(name, moduleID, SymbolKind.CONSTANT, qualifiers, annots, typeDescriptor, bSymbol);
        this.constValue = constValue;
        this.broaderType = broaderType;
    }

    @Override
    public Object constValue() {
        return this.constValue;
    }

    @Override
    public TypeSymbol broaderTypeDescriptor() {
        return this.broaderType;
    }

    @Override
    public TypeDescKind typeKind() {
        return TypeDescKind.SINGLETON;
    }

    @Override
    public String signature() {
        return this.typeDescriptor().signature();
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        return this.typeDescriptor().langLibMethods();
    }

    @Override
    public boolean assignableTo(TypeSymbol targetType) {
        return this.typeDescriptor().assignableTo(targetType);
    }

    public static class ConstantSymbolBuilder
    extends BallerinaVariableSymbol.VariableSymbolBuilder {
        private Object constantValue;
        private TypeSymbol broaderType;

        public ConstantSymbolBuilder(String name, PackageID moduleID, BSymbol symbol) {
            super(name, moduleID, symbol);
        }

        @Override
        public BallerinaConstantSymbol build() {
            return new BallerinaConstantSymbol(this.name, this.moduleID, this.qualifiers, this.annots, this.typeDescriptor, this.broaderType, this.constantValue, this.bSymbol);
        }

        public ConstantSymbolBuilder withConstValue(Object constValue) {
            this.constantValue = constValue;
            return this;
        }

        @Override
        public ConstantSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            super.withTypeDescriptor(typeDescriptor);
            return this;
        }

        public ConstantSymbolBuilder withBroaderTypeDescriptor(TypeSymbol typeDescriptor) {
            this.broaderType = typeDescriptor;
            return this;
        }
    }
}

