/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;

public class BallerinaEnumSymbol
extends BallerinaTypeDefinitionSymbol
implements EnumSymbol {
    private List<ConstantSymbol> members;
    private List<AnnotationSymbol> annots;

    protected BallerinaEnumSymbol(String name, PackageID moduleID, List<ConstantSymbol> members, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, TypeSymbol typeDescriptor, BSymbol bSymbol) {
        super(name, moduleID, qualifiers, typeDescriptor, bSymbol);
        this.members = Collections.unmodifiableList(members);
        this.annots = annots;
    }

    @Override
    public List<ConstantSymbol> members() {
        return this.members;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public SymbolKind kind() {
        return SymbolKind.ENUM;
    }

    public static class EnumSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<EnumSymbolBuilder> {
        protected List<ConstantSymbol> members;
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected List<AnnotationSymbol> annots = new ArrayList<AnnotationSymbol>();
        protected TypeSymbol typeDescriptor;

        public EnumSymbolBuilder(String name, PackageID moduleID, BSymbol symbol) {
            super(name, moduleID, SymbolKind.TYPE_DEFINITION, symbol);
        }

        public EnumSymbolBuilder withMembers(List<ConstantSymbol> members) {
            this.members = members;
            return this;
        }

        public EnumSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public EnumSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public EnumSymbolBuilder withAnnotation(AnnotationSymbol annot) {
            this.annots.add(annot);
            return this;
        }

        @Override
        public BallerinaEnumSymbol build() {
            return new BallerinaEnumSymbol(this.name, this.moduleID, this.members, this.qualifiers, this.annots, this.typeDescriptor, this.bSymbol);
        }
    }
}

