/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaDocumentation;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FieldSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaFieldSymbol
extends BallerinaSymbol
implements FieldSymbol {
    private final Documentation docAttachment;
    private final BField bField;
    private final CompilerContext context;
    private TypeSymbol typeDescriptor;
    private List<AnnotationSymbol> annots;
    private boolean deprecated;

    public BallerinaFieldSymbol(CompilerContext context, BField bField) {
        super(bField.name.value, bField.symbol.pkgID, SymbolKind.FIELD, bField.symbol);
        this.context = context;
        this.bField = bField;
        this.docAttachment = new BallerinaDocumentation(bField.symbol.markdownDocumentation);
        this.deprecated = Symbols.isFlagOn(bField.symbol.flags, 16L);
    }

    @Override
    public String name() {
        return this.bField.getName().getValue();
    }

    @Override
    public boolean isOptional() {
        return (this.bField.type.flags & 0x1000L) == 4096L;
    }

    @Override
    public boolean hasDefaultValue() {
        return !this.isOptional() && (this.bField.symbol.flags & 0x100L) != 256L;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        if (this.typeDescriptor == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.typeDescriptor = typesFactory.getTypeDescriptor(this.bField.type);
        }
        return this.typeDescriptor;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        if (this.annots != null) {
            return this.annots;
        }
        ArrayList<BallerinaAnnotationSymbol> annots = new ArrayList<BallerinaAnnotationSymbol>();
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        for (org.ballerinalang.model.symbols.AnnotationSymbol annotationSymbol : this.bField.symbol.getAnnotations()) {
            annots.add(symbolFactory.createAnnotationSymbol((BAnnotationSymbol)annotationSymbol));
        }
        this.annots = Collections.unmodifiableList(annots);
        return this.annots;
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    @Override
    public Optional<Documentation> documentation() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public Optional<Qualifier> qualifier() {
        if ((this.bField.symbol.flags & 1L) == 1L) {
            return Optional.of(Qualifier.PUBLIC);
        }
        if ((this.bField.symbol.flags & 0x400L) == 1024L) {
            return Optional.of(Qualifier.PRIVATE);
        }
        return Optional.empty();
    }

    @Override
    public String signature() {
        StringBuilder signature = new StringBuilder(this.typeDescriptor().signature() + " " + this.name());
        if (this.isOptional()) {
            signature.append("?");
        }
        return signature.toString();
    }
}

