/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFieldSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaMethodSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FieldSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaObjectTypeSymbol
extends AbstractTypeSymbol
implements ObjectTypeSymbol {
    private List<ObjectTypeSymbol.TypeQualifier> typeQualifiers;
    private List<FieldSymbol> objectFields;
    private List<MethodSymbol> methods;
    private List<TypeSymbol> typeInclusions;

    public BallerinaObjectTypeSymbol(CompilerContext context, ModuleID moduleID, BObjectType objectType) {
        super(context, TypeDescKind.OBJECT, moduleID, objectType);
    }

    @Override
    public List<ObjectTypeSymbol.TypeQualifier> typeQualifiers() {
        if (this.typeQualifiers != null) {
            return this.typeQualifiers;
        }
        this.typeQualifiers = new ArrayList<ObjectTypeSymbol.TypeQualifier>();
        BObjectType objectType = (BObjectType)this.getBType();
        if ((objectType.tsymbol.flags & 0x10000L) == 65536L) {
            this.typeQualifiers.add(ObjectTypeSymbol.TypeQualifier.CLIENT);
        }
        return this.typeQualifiers;
    }

    @Override
    public List<FieldSymbol> fieldDescriptors() {
        if (this.objectFields == null) {
            this.objectFields = new ArrayList<FieldSymbol>();
            for (BField field : ((BObjectType)this.getBType()).fields.values()) {
                this.objectFields.add(new BallerinaFieldSymbol(this.context, field));
            }
        }
        return this.objectFields;
    }

    @Override
    public List<MethodSymbol> methods() {
        if (this.methods == null) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            ArrayList<BallerinaMethodSymbol> methods = new ArrayList<BallerinaMethodSymbol>();
            for (BAttachedFunction attachedFunc : ((BObjectTypeSymbol)this.getBType().tsymbol).attachedFuncs) {
                methods.add(symbolFactory.createMethodSymbol(attachedFunc.symbol, attachedFunc.funcName.getValue()));
            }
            this.methods = Collections.unmodifiableList(methods);
        }
        return this.methods;
    }

    @Override
    public List<TypeSymbol> typeInclusions() {
        if (this.typeInclusions == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            List inclusions = ((BObjectType)this.getBType()).typeInclusions;
            ArrayList<TypeSymbol> typeRefs = new ArrayList<TypeSymbol>();
            for (BType inclusion : inclusions) {
                TypeSymbol type = typesFactory.getTypeDescriptor(inclusion);
                if (type == null) continue;
                typeRefs.add(type);
            }
            this.typeInclusions = Collections.unmodifiableList(typeRefs);
        }
        return this.typeInclusions;
    }

    @Override
    public String signature() {
        StringBuilder signature = new StringBuilder();
        StringJoiner qualifierJoiner = new StringJoiner(" ");
        StringJoiner fieldJoiner = new StringJoiner(";");
        StringJoiner methodJoiner = new StringJoiner(" ");
        for (ObjectTypeSymbol.TypeQualifier typeQualifier : this.typeQualifiers()) {
            String value = typeQualifier.getValue();
            qualifierJoiner.add(value);
        }
        qualifierJoiner.add("object {");
        signature.append(qualifierJoiner.toString());
        this.fieldDescriptors().forEach(objectFieldDescriptor -> fieldJoiner.add(objectFieldDescriptor.signature()));
        this.methods().forEach(method -> methodJoiner.add(method.signature()).add(";"));
        return signature.append(fieldJoiner.toString()).append(methodJoiner.toString()).append("}").toString();
    }
}

