/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;

public class BallerinaParameterSymbol
implements ParameterSymbol {
    private List<Qualifier> qualifiers;
    private List<AnnotationSymbol> annots;
    private String parameterName;
    private TypeSymbol typeDescriptor;
    private ParameterKind kind;

    public BallerinaParameterSymbol(String parameterName, TypeSymbol typeDescriptor, List<Qualifier> qualifiers, List<AnnotationSymbol> annots, ParameterKind kind) {
        this.parameterName = parameterName;
        this.typeDescriptor = typeDescriptor;
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.annots = Collections.unmodifiableList(annots);
        this.kind = kind;
    }

    @Override
    public Optional<String> name() {
        return Optional.ofNullable(this.parameterName);
    }

    @Override
    public TypeSymbol typeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public List<AnnotationSymbol> annotations() {
        return this.annots;
    }

    @Override
    public String signature() {
        Object signature;
        StringJoiner joiner = new StringJoiner(" ");
        this.qualifiers().forEach(accessModifier -> joiner.add(accessModifier.getValue()));
        if (this.kind() == ParameterKind.REST) {
            signature = this.typeDescriptor().signature();
            signature = ((String)signature).substring(0, ((String)signature).length() - 2) + "...";
        } else {
            signature = this.typeDescriptor().signature();
        }
        joiner.add((CharSequence)signature);
        if (this.name().isPresent()) {
            joiner.add(this.name().get());
        }
        return joiner.toString();
    }

    @Override
    public ParameterKind kind() {
        return this.kind;
    }
}

