/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFieldSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaRecordTypeSymbol
extends AbstractTypeSymbol
implements RecordTypeSymbol {
    private List<FieldSymbol> fieldSymbols;
    private final boolean isInclusive;
    private TypeSymbol restTypeDesc;
    private List<TypeSymbol> typeInclusions;

    public BallerinaRecordTypeSymbol(CompilerContext context, ModuleID moduleID, BRecordType recordType) {
        super(context, TypeDescKind.RECORD, moduleID, recordType);
        this.isInclusive = !recordType.sealed;
    }

    @Override
    public List<FieldSymbol> fieldDescriptors() {
        if (this.fieldSymbols == null) {
            this.fieldSymbols = new ArrayList<FieldSymbol>();
            for (BField field : ((BRecordType)this.getBType()).fields.values()) {
                this.fieldSymbols.add(new BallerinaFieldSymbol(this.context, field));
            }
        }
        return this.fieldSymbols;
    }

    @Override
    public boolean inclusive() {
        return this.isInclusive;
    }

    @Override
    public Optional<TypeSymbol> restTypeDescriptor() {
        if (this.restTypeDesc == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.restTypeDesc = typesFactory.getTypeDescriptor(((BRecordType)this.getBType()).restFieldType);
        }
        return Optional.ofNullable(this.restTypeDesc);
    }

    @Override
    public List<TypeSymbol> typeInclusions() {
        if (this.typeInclusions == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            List inclusions = ((BRecordType)this.getBType()).typeInclusions;
            ArrayList<TypeSymbol> typeRefs = new ArrayList<TypeSymbol>();
            for (BType inclusion : inclusions) {
                TypeSymbol type = typesFactory.getTypeDescriptor(inclusion);
                if (type == null) continue;
                typeRefs.add(type);
            }
            this.typeInclusions = Collections.unmodifiableList(typeRefs);
        }
        return this.typeInclusions;
    }

    @Override
    public String signature() {
        StringJoiner joiner = this.isInclusive ? new StringJoiner(" ", "{ ", " }") : new StringJoiner(" ", "{| ", " |}");
        for (FieldSymbol fieldSymbol : this.fieldDescriptors()) {
            String ballerinaFieldSignature = fieldSymbol.signature() + ";";
            joiner.add(ballerinaFieldSignature);
        }
        this.restTypeDescriptor().ifPresent(typeDescriptor -> joiner.add(typeDescriptor.signature() + "...;"));
        return "record " + joiner.toString();
    }
}

