/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.LangLibrary;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.SingletonTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import java.util.List;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaSingletonTypeSymbol
extends AbstractTypeSymbol
implements SingletonTypeSymbol {
    private String typeName;

    public BallerinaSingletonTypeSymbol(CompilerContext context, ModuleID moduleID, BLangExpression shape, BType bType) {
        super(context, TypeDescKind.SINGLETON, moduleID, bType);
        this.typeName = shape.toString();
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        if (this.langLibFunctions == null) {
            LangLibrary langLibrary = LangLibrary.getInstance(this.context);
            BFiniteType internalType = (BFiniteType)this.getBType();
            BType valueType = internalType.getValueSpace().iterator().next().type;
            List<FunctionSymbol> functions = langLibrary.getMethods(valueType.getKind());
            this.langLibFunctions = this.filterLangLibMethods(functions, valueType);
        }
        return this.langLibFunctions;
    }

    @Override
    public String signature() {
        return this.typeName;
    }
}

