/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.BallerinaModuleID;
import io.ballerina.compiler.api.impl.symbols.BallerinaDocumentation;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;

public class BallerinaSymbol
implements Symbol {
    private final String name;
    private final PackageID moduleID;
    private final SymbolKind symbolKind;
    private final Documentation docAttachment;
    private final Location position;
    private final BSymbol internalSymbol;

    protected BallerinaSymbol(String name, PackageID moduleID, SymbolKind symbolKind, BSymbol symbol) {
        this.name = name;
        this.moduleID = moduleID;
        this.symbolKind = symbolKind;
        this.docAttachment = this.getDocAttachment(symbol);
        if (symbol == null) {
            throw new IllegalArgumentException("'symbol' cannot be null");
        }
        this.internalSymbol = symbol;
        this.position = new BLangDiagnosticLocation(symbol.pos.lineRange().filePath(), symbol.pos.lineRange().startLine().line(), symbol.pos.lineRange().endLine().line(), symbol.pos.lineRange().startLine().offset(), symbol.pos.lineRange().endLine().offset());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ModuleID moduleID() {
        return new BallerinaModuleID(this.moduleID);
    }

    @Override
    public SymbolKind kind() {
        return this.symbolKind;
    }

    @Override
    public Optional<Documentation> docAttachment() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public Location location() {
        return this.position;
    }

    public BSymbol getInternalSymbol() {
        return this.internalSymbol;
    }

    private Documentation getDocAttachment(BSymbol symbol) {
        return symbol == null ? null : new BallerinaDocumentation(symbol.markdownDocumentation);
    }

    protected static abstract class SymbolBuilder<T extends SymbolBuilder<T>> {
        protected String name;
        protected PackageID moduleID;
        protected SymbolKind ballerinaSymbolKind;
        protected BSymbol bSymbol;

        public SymbolBuilder(String name, PackageID moduleID, SymbolKind symbolKind, BSymbol bSymbol) {
            this.name = name;
            this.moduleID = moduleID;
            this.ballerinaSymbolKind = symbolKind;
            this.bSymbol = bSymbol;
        }

        public abstract BallerinaSymbol build();
    }
}

