/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaTableTypeSymbol
extends AbstractTypeSymbol
implements TableTypeSymbol {
    private TypeSymbol rowTypeParameter;
    private TypeSymbol keyConstraintTypeParameter;
    private List<String> keySpecifiers;
    private String signature;

    public BallerinaTableTypeSymbol(CompilerContext context, ModuleID moduleID, BTableType tableType) {
        super(context, TypeDescKind.TABLE, moduleID, tableType);
    }

    @Override
    public TypeSymbol rowTypeParameter() {
        if (this.rowTypeParameter == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.rowTypeParameter = typesFactory.getTypeDescriptor(((BTableType)this.getBType()).constraint);
        }
        return this.rowTypeParameter;
    }

    @Override
    public Optional<TypeSymbol> keyConstraintTypeParameter() {
        if (this.keyConstraintTypeParameter == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.keyConstraintTypeParameter = typesFactory.getTypeDescriptor(((BTableType)this.getBType()).keyTypeConstraint);
        }
        return Optional.ofNullable(this.keyConstraintTypeParameter);
    }

    @Override
    public List<String> keySpecifiers() {
        if (this.keySpecifiers == null) {
            List<String> specifiers = ((BTableType)this.getBType()).fieldNameList;
            if (specifiers == null) {
                specifiers = new ArrayList<String>();
            }
            this.keySpecifiers = Collections.unmodifiableList(specifiers);
        }
        return this.keySpecifiers;
    }

    @Override
    public String signature() {
        if (this.signature == null) {
            StringBuilder sigBuilder = new StringBuilder("table");
            Optional<TypeSymbol> keyConstraint = this.keyConstraintTypeParameter();
            List<String> keySpecifiers = this.keySpecifiers();
            sigBuilder.append('<').append(this.rowTypeParameter().signature()).append('>');
            keyConstraint.ifPresent(t -> sigBuilder.append(" key<").append(t.signature()).append(">"));
            if (!keySpecifiers.isEmpty()) {
                StringJoiner specifiersBuilder = new StringJoiner(",", "(", ")");
                for (String keySpecifier : keySpecifiers) {
                    specifiersBuilder.add(keySpecifier);
                }
                sigBuilder.append(" key").append(specifiersBuilder.toString());
            }
            this.signature = sigBuilder.toString();
        }
        return this.signature;
    }
}

