/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.BallerinaModuleID;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnyTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaAnydataTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaArrayTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaErrorTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFutureTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaHandleTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaJSONTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaMapTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaNilTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaObjectTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaReadonlyTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaRecordTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSimpleTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSingletonTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaStreamTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTableTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTupleTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeDescTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeReferenceTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaUnionTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Set;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStringSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class TypesFactory {
    private static final CompilerContext.Key<TypesFactory> TYPES_FACTORY_KEY = new CompilerContext.Key();
    private final CompilerContext context;
    private final SymbolFactory symbolFactory;

    private TypesFactory(CompilerContext context) {
        context.put(TYPES_FACTORY_KEY, this);
        this.context = context;
        this.symbolFactory = SymbolFactory.getInstance(context);
    }

    public static TypesFactory getInstance(CompilerContext context) {
        TypesFactory typesFactory = context.get(TYPES_FACTORY_KEY);
        if (typesFactory == null) {
            typesFactory = new TypesFactory(context);
        }
        return typesFactory;
    }

    public TypeSymbol getTypeDescriptor(BType bType) {
        return this.getTypeDescriptor(bType, false);
    }

    public TypeSymbol getTypeDescriptor(BType bType, boolean rawTypeOnly) {
        BallerinaModuleID moduleID;
        if (bType == null || bType.tag == 23) {
            return null;
        }
        BallerinaModuleID ballerinaModuleID = moduleID = bType.tsymbol == null ? null : new BallerinaModuleID(bType.tsymbol.pkgID);
        if (TypesFactory.isTypeReference(bType, rawTypeOnly)) {
            return new BallerinaTypeReferenceTypeSymbol(this.context, moduleID, bType, bType.tsymbol.getName().getValue());
        }
        switch (bType.getKind()) {
            case INT: {
                if (bType instanceof BIntSubType) {
                    return new BallerinaSimpleTypeSymbol(this.context, moduleID, bType.name.getValue(), bType);
                }
                return this.createSimpleTypedesc(moduleID, bType);
            }
            case STRING: {
                if (bType instanceof BStringSubType) {
                    return new BallerinaSimpleTypeSymbol(this.context, moduleID, bType.name.getValue(), bType);
                }
                return this.createSimpleTypedesc(moduleID, bType);
            }
            case ANY: {
                return new BallerinaAnyTypeSymbol(this.context, moduleID, (BAnyType)bType);
            }
            case ANYDATA: {
                return new BallerinaAnydataTypeSymbol(this.context, moduleID, (BAnydataType)bType);
            }
            case HANDLE: {
                return new BallerinaHandleTypeSymbol(this.context, moduleID, (BHandleType)bType);
            }
            case JSON: {
                return new BallerinaJSONTypeSymbol(this.context, moduleID, (BJSONType)bType);
            }
            case READONLY: {
                return new BallerinaReadonlyTypeSymbol(this.context, moduleID, (BReadonlyType)bType);
            }
            case TABLE: {
                return new BallerinaTableTypeSymbol(this.context, moduleID, (BTableType)bType);
            }
            case XML: {
                if (bType instanceof BXMLSubType) {
                    return new BallerinaXMLTypeSymbol(this.context, (ModuleID)moduleID, (BXMLSubType)bType);
                }
                return new BallerinaXMLTypeSymbol(this.context, (ModuleID)moduleID, (BXMLType)bType);
            }
            case OBJECT: {
                BallerinaObjectTypeSymbol objType = new BallerinaObjectTypeSymbol(this.context, moduleID, (BObjectType)bType);
                if (Symbols.isFlagOn(bType.tsymbol.flags, 0x10000000L)) {
                    return this.symbolFactory.createClassSymbol((BClassSymbol)bType.tsymbol, bType.tsymbol.name.value, objType);
                }
                return objType;
            }
            case RECORD: {
                return new BallerinaRecordTypeSymbol(this.context, moduleID, (BRecordType)bType);
            }
            case ERROR: {
                return new BallerinaErrorTypeSymbol(this.context, moduleID, (BErrorType)bType);
            }
            case UNION: {
                return new BallerinaUnionTypeSymbol(this.context, (ModuleID)moduleID, (BUnionType)bType);
            }
            case FUTURE: {
                return new BallerinaFutureTypeSymbol(this.context, moduleID, (BFutureType)bType);
            }
            case MAP: {
                return new BallerinaMapTypeSymbol(this.context, moduleID, (BMapType)bType);
            }
            case STREAM: {
                return new BallerinaStreamTypeSymbol(this.context, moduleID, (BStreamType)bType);
            }
            case ARRAY: {
                return new BallerinaArrayTypeSymbol(this.context, moduleID, (BArrayType)bType);
            }
            case TUPLE: {
                return new BallerinaTupleTypeSymbol(this.context, moduleID, (BTupleType)bType);
            }
            case TYPEDESC: {
                return new BallerinaTypeDescTypeSymbol(this.context, moduleID, (BTypedescType)bType);
            }
            case NIL: {
                return new BallerinaNilTypeSymbol(this.context, moduleID, (BNilType)bType);
            }
            case FINITE: {
                BFiniteType finiteType = (BFiniteType)bType;
                Set<BLangExpression> valueSpace = finiteType.getValueSpace();
                if (valueSpace.size() == 1) {
                    BLangExpression shape = valueSpace.iterator().next();
                    return new BallerinaSingletonTypeSymbol(this.context, moduleID, shape, bType);
                }
                return new BallerinaUnionTypeSymbol(this.context, (ModuleID)moduleID, finiteType);
            }
            case FUNCTION: {
                return new BallerinaFunctionTypeSymbol(this.context, moduleID, (BInvokableTypeSymbol)bType.tsymbol);
            }
        }
        return new BallerinaSimpleTypeSymbol(this.context, moduleID, bType);
    }

    private BallerinaSimpleTypeSymbol createSimpleTypedesc(ModuleID moduleID, BType internalType) {
        return new BallerinaSimpleTypeSymbol(this.context, moduleID, internalType);
    }

    private static boolean isTypeReference(BType bType, boolean rawTypeOnly) {
        if (rawTypeOnly || bType.tsymbol == null) {
            return false;
        }
        if ((bType.tsymbol.flags & 0x800L) == 2048L) {
            return false;
        }
        TypeKind kind = bType.getKind();
        return kind == TypeKind.RECORD || kind == TypeKind.OBJECT || bType.tsymbol.isLabel || bType instanceof BIntSubType || bType instanceof BStringSubType || bType instanceof BXMLSubType || bType.tsymbol.kind == SymbolKind.ENUM;
    }

    public static TypeDescKind getTypeDescKind(TypeKind bTypeKind) {
        switch (bTypeKind) {
            case ANY: {
                return TypeDescKind.ANY;
            }
            case ANYDATA: {
                return TypeDescKind.ANYDATA;
            }
            case ARRAY: {
                return TypeDescKind.ARRAY;
            }
            case BOOLEAN: {
                return TypeDescKind.BOOLEAN;
            }
            case BYTE: {
                return TypeDescKind.BYTE;
            }
            case DECIMAL: {
                return TypeDescKind.DECIMAL;
            }
            case FLOAT: {
                return TypeDescKind.FLOAT;
            }
            case HANDLE: {
                return TypeDescKind.HANDLE;
            }
            case INT: {
                return TypeDescKind.INT;
            }
            case NEVER: {
                return TypeDescKind.NEVER;
            }
            case NIL: {
                return TypeDescKind.NIL;
            }
            case STRING: {
                return TypeDescKind.STRING;
            }
            case JSON: {
                return TypeDescKind.JSON;
            }
            case XML: {
                return TypeDescKind.XML;
            }
            case FUNCTION: {
                return TypeDescKind.FUNCTION;
            }
            case FUTURE: {
                return TypeDescKind.FUTURE;
            }
            case MAP: {
                return TypeDescKind.MAP;
            }
            case OBJECT: {
                return TypeDescKind.OBJECT;
            }
            case STREAM: {
                return TypeDescKind.STREAM;
            }
            case TUPLE: {
                return TypeDescKind.TUPLE;
            }
            case TYPEDESC: {
                return TypeDescKind.TYPEDESC;
            }
            case UNION: {
                return TypeDescKind.UNION;
            }
            case INTERSECTION: {
                return TypeDescKind.INTERSECTION;
            }
            case ERROR: {
                return TypeDescKind.ERROR;
            }
        }
        return null;
    }
}

