/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.parser.AbstractParser;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;

public class DocumentationParser
extends AbstractParser {
    protected DocumentationParser(AbstractTokenReader tokenReader) {
        super(tokenReader);
    }

    @Override
    public STNode parse() {
        return this.parseDocumentationLines();
    }

    private STNode parseDocumentationLines() {
        ArrayList<STNode> docLines = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (nextToken.kind == SyntaxKind.HASH_TOKEN) {
            docLines.add(this.parseSingleDocumentationLine());
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(docLines);
    }

    private STNode parseSingleDocumentationLine() {
        STToken hashToken = this.consume();
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.PLUS_TOKEN) {
            return this.parseParameterDocumentationLine(hashToken);
        }
        if (nextToken.kind == SyntaxKind.DEPRECATION_LITERAL) {
            return this.parseDeprecationDocumentationLine(hashToken);
        }
        return this.parseDocumentationLine(hashToken);
    }

    private STNode parseDeprecationDocumentationLine(STNode hashToken) {
        STToken deprecationLiteral = this.consume();
        List<STNode> docElements = this.parseDocumentationElements();
        docElements.add(0, deprecationLiteral);
        STNode docElementList = STNodeFactory.createNodeList(docElements);
        return this.createMarkdownDeprecationDocumentationLineNode(hashToken, docElementList);
    }

    private STNode parseDocumentationLine(STNode hashToken) {
        List<STNode> docElements = this.parseDocumentationElements();
        STNode docElementList = STNodeFactory.createNodeList(docElements);
        switch (docElements.size()) {
            case 0: {
                return this.createMarkdownDocumentationLineNode(hashToken, docElementList);
            }
            case 1: {
                STNode docElement = docElements.get(0);
                if (docElement.kind != SyntaxKind.DOCUMENTATION_DESCRIPTION) break;
                return this.createMarkdownDocumentationLineNode(hashToken, docElementList);
            }
        }
        return this.createMarkdownReferenceDocumentationLineNode(hashToken, docElementList);
    }

    private List<STNode> parseDocumentationElements() {
        ArrayList<STNode> docElements = new ArrayList<STNode>();
        SyntaxKind nextTokenKind = this.peek().kind;
        while (!this.isEndOfIntermediateDocumentation(nextTokenKind)) {
            STNode docElement = nextTokenKind == SyntaxKind.DOCUMENTATION_DESCRIPTION ? this.consume() : this.parseDocumentationReference();
            docElements.add(docElement);
            nextTokenKind = this.peek().kind;
        }
        return docElements;
    }

    private STNode parseDocumentationReference() {
        STNode referenceType = STNodeFactory.createEmptyNode();
        if (this.isDocumentReferenceType(this.peek().kind)) {
            referenceType = this.consume();
        }
        STNode startBacktick = this.parseBacktickToken();
        STNode backtickContent = this.parseBacktickContent();
        STNode endBacktick = this.parseBacktickToken();
        return STNodeFactory.createDocumentationReferenceNode(referenceType, startBacktick, backtickContent, endBacktick);
    }

    private boolean isDocumentReferenceType(SyntaxKind kind) {
        switch (kind) {
            case TYPE_DOC_REFERENCE_TOKEN: 
            case SERVICE_DOC_REFERENCE_TOKEN: 
            case VARIABLE_DOC_REFERENCE_TOKEN: 
            case VAR_DOC_REFERENCE_TOKEN: 
            case ANNOTATION_DOC_REFERENCE_TOKEN: 
            case MODULE_DOC_REFERENCE_TOKEN: 
            case FUNCTION_DOC_REFERENCE_TOKEN: 
            case PARAMETER_DOC_REFERENCE_TOKEN: 
            case CONST_DOC_REFERENCE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseParameterDocumentationLine(STNode hashToken) {
        STToken plusToken = this.consume();
        STNode parameterName = this.parseParameterName();
        STNode dashToken = this.parseMinusToken();
        List<STNode> docElements = this.parseDocumentationElements();
        STNode docElementList = STNodeFactory.createNodeList(docElements);
        SyntaxKind kind = parameterName.kind == SyntaxKind.RETURN_KEYWORD ? SyntaxKind.MARKDOWN_RETURN_PARAMETER_DOCUMENTATION_LINE : SyntaxKind.MARKDOWN_PARAMETER_DOCUMENTATION_LINE;
        return STNodeFactory.createMarkdownParameterDocumentationLineNode(kind, hashToken, plusToken, parameterName, dashToken, docElementList);
    }

    private boolean isEndOfIntermediateDocumentation(SyntaxKind kind) {
        switch (kind) {
            case DOCUMENTATION_DESCRIPTION: 
            case PLUS_TOKEN: 
            case PARAMETER_NAME: 
            case MINUS_TOKEN: 
            case BACKTICK_TOKEN: 
            case BACKTICK_CONTENT: 
            case RETURN_KEYWORD: 
            case DEPRECATION_LITERAL: {
                return false;
            }
        }
        return !this.isDocumentReferenceType(kind);
    }

    private STNode parseParameterName() {
        SyntaxKind tokenKind = this.peek().kind;
        if (tokenKind == SyntaxKind.PARAMETER_NAME || tokenKind == SyntaxKind.RETURN_KEYWORD) {
            return this.consume();
        }
        return STNodeFactory.createMissingToken(SyntaxKind.PARAMETER_NAME);
    }

    private STNode parseMinusToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.MINUS_TOKEN) {
            return this.consume();
        }
        return STNodeFactory.createMissingToken(SyntaxKind.MINUS_TOKEN);
    }

    private STNode parseBacktickToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BACKTICK_TOKEN) {
            return this.consume();
        }
        return STNodeFactory.createMissingToken(SyntaxKind.BACKTICK_TOKEN);
    }

    private STNode parseBacktickContent() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            STToken identifier = this.consume();
            return this.parseBacktickExpr(identifier);
        }
        return this.parseBacktickContentToken();
    }

    private STNode parseBacktickContentToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BACKTICK_CONTENT) {
            return this.consume();
        }
        return STNodeFactory.createMissingToken(SyntaxKind.BACKTICK_CONTENT);
    }

    private STNode parseBacktickExpr(STNode identifier) {
        STNode referenceName = this.parseQualifiedIdentifier(identifier);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case BACKTICK_TOKEN: {
                return referenceName;
            }
            case DOT_TOKEN: {
                STToken dotToken = this.consume();
                return this.parseMethodCall(referenceName, dotToken);
            }
        }
        return this.parseFuncCall(referenceName);
    }

    private STNode parseQualifiedIdentifier(STNode identifier) {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.COLON_TOKEN) {
            STToken colon = this.consume();
            return this.parseQualifiedIdentifier(identifier, colon);
        }
        return STNodeFactory.createSimpleNameReferenceNode(identifier);
    }

    private STNode parseQualifiedIdentifier(STNode identifier, STNode colon) {
        STNode refName = this.parseIdentifier();
        return STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, refName);
    }

    private STNode parseIdentifier() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        return STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
    }

    private STNode parseFuncCall(STNode referenceName) {
        STNode openParen = this.parseOpenParenthesis();
        STNode args = STNodeFactory.createEmptyNodeList();
        STNode closeParen = this.parseCloseParenthesis();
        return STNodeFactory.createFunctionCallExpressionNode(referenceName, openParen, args, closeParen);
    }

    private STNode parseMethodCall(STNode referenceName, STNode dotToken) {
        STNode methodName = this.parseSimpleNameReference();
        STNode openParen = this.parseOpenParenthesis();
        STNode args = STNodeFactory.createEmptyNodeList();
        STNode closeParen = this.parseCloseParenthesis();
        return STNodeFactory.createMethodCallExpressionNode(referenceName, dotToken, methodName, openParen, args, closeParen);
    }

    private STNode parseSimpleNameReference() {
        STNode identifier = this.parseIdentifier();
        return STNodeFactory.createSimpleNameReferenceNode(identifier);
    }

    private STNode parseOpenParenthesis() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            return this.consume();
        }
        return STNodeFactory.createMissingToken(SyntaxKind.OPEN_PAREN_TOKEN);
    }

    private STNode parseCloseParenthesis() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            return this.consume();
        }
        return STNodeFactory.createMissingToken(SyntaxKind.CLOSE_PAREN_TOKEN);
    }

    private STNode createMarkdownDocumentationLineNode(STNode hashToken, STNode documentationElements) {
        return STNodeFactory.createMarkdownDocumentationLineNode(SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, hashToken, documentationElements);
    }

    private STNode createMarkdownDeprecationDocumentationLineNode(STNode hashToken, STNode documentationElements) {
        return STNodeFactory.createMarkdownDocumentationLineNode(SyntaxKind.MARKDOWN_DEPRECATION_DOCUMENTATION_LINE, hashToken, documentationElements);
    }

    private STNode createMarkdownReferenceDocumentationLineNode(STNode hashToken, STNode documentationElements) {
        return STNodeFactory.createMarkdownDocumentationLineNode(SyntaxKind.MARKDOWN_REFERENCE_DOCUMENTATION_LINE, hashToken, documentationElements);
    }
}

