/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.incremental;

import io.ballerina.compiler.internal.parser.BallerinaLexer;
import io.ballerina.compiler.internal.parser.incremental.NodePointer;
import io.ballerina.compiler.internal.parser.incremental.TextEditRange;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.parser.utils.PersistentStack;
import io.ballerina.compiler.internal.syntax.SyntaxUtils;

class HybridNode {
    static final HybridNode EMPTY = new HybridNode(null, null);
    private final State state;
    private final STNode node;

    HybridNode(STNode node, State state) {
        this.node = node;
        this.state = state;
    }

    State state() {
        return this.state;
    }

    STToken token() {
        return SyntaxUtils.isToken(this.node) ? (STToken)this.node : null;
    }

    STNode subtree() {
        return SyntaxUtils.isNonTerminalNode(this.node) ? this.node : null;
    }

    static class State {
        int oldTextOffset;
        int newTextOffset;
        BallerinaLexer lexer;
        NodePointer oldTreePtr;
        PersistentStack<TextEditRange> textEditRanges;

        State(int oldTextOffset, int newTextOffset, BallerinaLexer lexer, NodePointer oldTreePtr, PersistentStack<TextEditRange> textEditRanges) {
            this.oldTextOffset = oldTextOffset;
            this.newTextOffset = newTextOffset;
            this.lexer = lexer;
            this.oldTreePtr = oldTreePtr;
            this.textEditRanges = textEditRanges;
        }

        State cloneState() {
            return new State(this.oldTextOffset, this.newTextOffset, this.lexer, this.oldTreePtr.clonePointer(), this.textEditRanges);
        }
    }

    static enum Source {
        OLD_SYNTAX_TREE,
        NEW_TEXT_DOCUMENT;

    }

    static enum Kind {
        SUBTREE,
        TOKEN;

    }
}

