/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.incremental;

import io.ballerina.compiler.internal.parser.BallerinaLexer;
import io.ballerina.compiler.internal.parser.incremental.HybridNode;
import io.ballerina.compiler.internal.parser.incremental.HybridNodes;
import io.ballerina.compiler.internal.parser.incremental.NodePointer;
import io.ballerina.compiler.internal.parser.incremental.TextEditRange;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.parser.utils.PersistentStack;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;

public class HybridNodeStorage {
    private final List<HybridNode> hybridNodeList = new ArrayList<HybridNode>(20);
    private int consumedNodeIndex = 0;
    private int peekedNodeIndex = 0;
    private HybridNode currentToken = null;
    private HybridNode currentNode = null;

    public HybridNodeStorage(SyntaxTree oldTree, BallerinaLexer lexer, TextDocumentChange textDocumentChange) {
        this.hybridNodeList.add(this.createInitialNode((ModulePartNode)oldTree.rootNode(), lexer, textDocumentChange));
        ++this.consumedNodeIndex;
        ++this.peekedNodeIndex;
    }

    HybridNode getCurrentToken() {
        return this.currentToken;
    }

    HybridNode consumeSubtree() {
        HybridNode hybridNode = this.currentNode;
        this.hybridNodeList.add(this.consumedNodeIndex++, hybridNode);
        this.peekedNodeIndex = this.consumedNodeIndex;
        this.currentNode = null;
        this.currentToken = null;
        return hybridNode;
    }

    HybridNode peekSubtree() {
        if (this.currentNode != null) {
            return this.currentNode;
        }
        this.currentNode = this.nextSubtree();
        return this.currentNode;
    }

    HybridNode consumeToken() {
        if (this.currentToken == null) {
            this.currentToken = this.peekToken();
        }
        HybridNode hybridNode = this.currentToken;
        this.currentToken = null;
        ++this.consumedNodeIndex;
        return hybridNode;
    }

    HybridNode peekToken() {
        if (this.currentToken != null) {
            return this.currentToken;
        }
        if (this.consumedNodeIndex >= this.peekedNodeIndex) {
            this.storeNextToken();
        }
        this.currentToken = this.peek(0);
        return this.currentToken;
    }

    HybridNode peekToken(int k) {
        while (this.consumedNodeIndex + k >= this.peekedNodeIndex) {
            this.storeNextToken();
        }
        return this.peek(k);
    }

    int getCurrentTokenIndex() {
        return this.peekedNodeIndex;
    }

    private HybridNode peek(int k) {
        return this.hybridNodeList.get(this.consumedNodeIndex + k);
    }

    private HybridNode lastConsumed() {
        return this.hybridNodeList.get(this.consumedNodeIndex - 1);
    }

    private HybridNode lastStored() {
        return this.hybridNodeList.get(this.peekedNodeIndex - 1);
    }

    private HybridNode nextSubtree() {
        HybridNode prevHybridNode = this.lastConsumed();
        return HybridNodes.nextNode(prevHybridNode, HybridNode.Kind.SUBTREE);
    }

    private void storeNextToken() {
        HybridNode prevHybridNode = this.lastStored();
        HybridNode hybridNode = HybridNodes.nextNode(prevHybridNode, HybridNode.Kind.TOKEN);
        this.storeToken(hybridNode);
    }

    private void storeToken(HybridNode hybridNode) {
        this.hybridNodeList.add(this.peekedNodeIndex++, hybridNode);
    }

    private HybridNode createInitialNode(ModulePartNode oldTree, BallerinaLexer lexer, TextDocumentChange textDocumentChange) {
        NodePointer oldTreePtr = new NodePointer(oldTree);
        PersistentStack<TextEditRange> textEditRanges = this.markAffectedRanges(oldTree, textDocumentChange);
        HybridNode.State state = new HybridNode.State(0, 0, lexer, oldTreePtr.nextChild(), textEditRanges);
        return new HybridNode(null, state);
    }

    private PersistentStack<TextEditRange> markAffectedRanges(ModulePartNode oldTree, TextDocumentChange textDocumentChange) {
        int textEditCount = textDocumentChange.getTextEditCount();
        PersistentStack<TextEditRange> markedTextEdits = PersistentStack.getEmpty();
        for (int index = textEditCount - 1; index >= 0; --index) {
            TextEdit textEdit = textDocumentChange.getTextEdit(index);
            markedTextEdits = markedTextEdits.push(this.markAffectedRange(oldTree, textEdit));
        }
        return markedTextEdits;
    }

    private TextEditRange markAffectedRange(ModulePartNode oldTree, TextEdit textEdit) {
        TextRange textRange = textEdit.range();
        Token affectedToken = oldTree.findToken(textRange.startOffset());
        if (affectedToken.textRangeWithMinutiae().startOffset() == 0) {
            return new TextEditRange(textRange.startOffset(), textRange.endOffset(), textEdit.text().length());
        }
        STToken internalToken = (STToken)affectedToken.internalNode();
        for (int lbIndex = 0; lbIndex < internalToken.lookbackTokenCount(); ++lbIndex) {
            affectedToken = oldTree.findToken(affectedToken.textRangeWithMinutiae().startOffset() - 1);
        }
        int affectedTokenStartOffset = affectedToken.textRangeWithMinutiae().startOffset();
        int newTextLength = textEdit.text().length() + (textRange.startOffset() - affectedTokenStartOffset);
        return new TextEditRange(affectedTokenStartOffset, textRange.endOffset(), newTextLength);
    }
}

