/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.incremental;

import io.ballerina.compiler.internal.parser.incremental.HybridNode;
import io.ballerina.compiler.internal.parser.incremental.TextEditRange;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.parser.utils.PersistentStack;
import io.ballerina.compiler.internal.syntax.SyntaxUtils;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.text.TextRange;

class HybridNodes {
    HybridNodes() {
    }

    static HybridNode nextNode(HybridNode prevNode, HybridNode.Kind kind) {
        HybridNode.State state = prevNode.state().cloneState();
        switch (kind) {
            case TOKEN: {
                return HybridNodes.nextToken(state);
            }
            case SUBTREE: {
                return HybridNodes.nextSubtree(state);
            }
        }
        throw new UnsupportedOperationException("Unsupported HybridNode.Kind: " + kind);
    }

    private static HybridNode nextSubtree(HybridNode.State state) {
        if (state.oldTreePtr.isAtEOF() || state.oldTextOffset != state.newTextOffset) {
            return null;
        }
        Node oldTreeNode = state.oldTreePtr.currentNode();
        while (SyntaxUtils.isNonTerminalNode(oldTreeNode)) {
            if (HybridNodes.isNodeReusable(oldTreeNode, state)) {
                int width = oldTreeNode.textRangeWithMinutiae().length();
                state.oldTextOffset += width;
                state.newTextOffset += width;
                state.oldTreePtr = state.oldTreePtr.nextSibling();
                return new HybridNode(oldTreeNode.internalNode(), state);
            }
            state.oldTreePtr = state.oldTreePtr.nextChild();
            oldTreeNode = state.oldTreePtr.currentNode();
        }
        return null;
    }

    private static HybridNode nextToken(HybridNode.State state) {
        HybridNode hybridNode = null;
        do {
            if (state.oldTreePtr.isAtEOF() || state.oldTextOffset > state.newTextOffset) {
                hybridNode = HybridNodes.tokenFromNewText(state);
                continue;
            }
            if (state.oldTextOffset < state.newTextOffset) {
                HybridNodes.syncOldWithNewTextOffset(HybridNodes.getTokenFromOldTree(state), state);
                continue;
            }
            hybridNode = HybridNodes.getReusableTokenFromOldTree(state);
        } while (hybridNode == null);
        return hybridNode;
    }

    private static void syncOldWithNewTextOffset(Token token, HybridNode.State state) {
        state.oldTextOffset += token.textRangeWithMinutiae().length();
        state.oldTreePtr = state.oldTreePtr.nextSibling();
        HybridNodes.removeInvalidTextEdits(token, state);
    }

    private static HybridNode getReusableTokenFromOldTree(HybridNode.State state) {
        Token token = HybridNodes.getTokenFromOldTree(state);
        if (HybridNodes.isNodeReusable(token, state)) {
            int width = token.textRangeWithMinutiae().length();
            state.oldTextOffset += width;
            state.newTextOffset += width;
            state.oldTreePtr = state.oldTreePtr.nextSibling();
            return new HybridNode(token.internalNode(), state);
        }
        HybridNodes.syncOldWithNewTextOffset(token, state);
        return null;
    }

    private static Token getTokenFromOldTree(HybridNode.State state) {
        if (SyntaxUtils.isToken(state.oldTreePtr.currentNode())) {
            return state.oldTreePtr.currentToken();
        }
        state.oldTreePtr = state.oldTreePtr.nextToken();
        return state.oldTreePtr.currentToken();
    }

    private static void removeInvalidTextEdits(Token oldToken, HybridNode.State state) {
        if (state.textEditRanges.isEmpty()) {
            return;
        }
        int nextOldTokenStartOffset = oldToken.textRangeWithMinutiae().endOffset();
        TextEditRange textEditRange = state.textEditRanges.peek();
        if (nextOldTokenStartOffset < textEditRange.oldEndOffset) {
            return;
        }
        state.textEditRanges = state.textEditRanges.pop();
        state.oldTextOffset += textEditRange.newTextLength - textEditRange.oldLength;
    }

    private static HybridNode tokenFromNewText(HybridNode.State state) {
        state.lexer.reset(state.newTextOffset);
        STToken token = state.lexer.nextToken();
        state.newTextOffset += token.widthWithMinutiae();
        return new HybridNode(token, state);
    }

    private static boolean isNodeReusable(Node node, HybridNode.State state) {
        if (node.internalNode().widthWithMinutiae() == 0) {
            return false;
        }
        return HybridNodes.noOverlapWithCurrentTextEdit(node, state.textEditRanges);
    }

    private static boolean noOverlapWithCurrentTextEdit(Node oldNode, PersistentStack<TextEditRange> textEditRanges) {
        if (textEditRanges.isEmpty()) {
            return true;
        }
        TextEditRange textEditRange = textEditRanges.peek();
        TextRange oldTokenRange = oldNode.textRangeWithMinutiae();
        return textEditRange.oldEndOffset < oldTokenRange.startOffset() || oldTokenRange.endOffset() < textEditRange.oldStartOffset;
    }
}

