/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STBracedExpressionNode
extends STExpressionNode {
    public final STNode openParen;
    public final STNode expression;
    public final STNode closeParen;

    STBracedExpressionNode(SyntaxKind kind, STNode openParen, STNode expression, STNode closeParen) {
        this(kind, openParen, expression, closeParen, Collections.emptyList());
    }

    STBracedExpressionNode(SyntaxKind kind, STNode openParen, STNode expression, STNode closeParen, Collection<STNodeDiagnostic> diagnostics) {
        super(kind, diagnostics);
        this.openParen = openParen;
        this.expression = expression;
        this.closeParen = closeParen;
        this.addChildren(openParen, expression, closeParen);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STBracedExpressionNode(this.kind, this.openParen, this.expression, this.closeParen, diagnostics);
    }

    public STBracedExpressionNode modify(SyntaxKind kind, STNode openParen, STNode expression, STNode closeParen) {
        if (this.checkForReferenceEquality(openParen, expression, closeParen)) {
            return this;
        }
        return new STBracedExpressionNode(kind, openParen, expression, closeParen, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new BracedExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

