/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ByteArrayLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STByteArrayLiteralNode
extends STExpressionNode {
    public final STNode type;
    public final STNode startBacktick;
    public final STNode content;
    public final STNode endBacktick;

    STByteArrayLiteralNode(STNode type, STNode startBacktick, STNode content, STNode endBacktick) {
        this(type, startBacktick, content, endBacktick, Collections.emptyList());
    }

    STByteArrayLiteralNode(STNode type, STNode startBacktick, STNode content, STNode endBacktick, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.BYTE_ARRAY_LITERAL, diagnostics);
        this.type = type;
        this.startBacktick = startBacktick;
        this.content = content;
        this.endBacktick = endBacktick;
        this.addChildren(type, startBacktick, content, endBacktick);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STByteArrayLiteralNode(this.type, this.startBacktick, this.content, this.endBacktick, diagnostics);
    }

    public STByteArrayLiteralNode modify(STNode type, STNode startBacktick, STNode content, STNode endBacktick) {
        if (this.checkForReferenceEquality(type, startBacktick, content, endBacktick)) {
            return this;
        }
        return new STByteArrayLiteralNode(type, startBacktick, content, endBacktick, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ByteArrayLiteralNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

