/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STMappingFieldNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ComputedNameFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STComputedNameFieldNode
extends STMappingFieldNode {
    public final STNode openBracket;
    public final STNode fieldNameExpr;
    public final STNode closeBracket;
    public final STNode colonToken;
    public final STNode valueExpr;

    STComputedNameFieldNode(STNode openBracket, STNode fieldNameExpr, STNode closeBracket, STNode colonToken, STNode valueExpr) {
        this(openBracket, fieldNameExpr, closeBracket, colonToken, valueExpr, Collections.emptyList());
    }

    STComputedNameFieldNode(STNode openBracket, STNode fieldNameExpr, STNode closeBracket, STNode colonToken, STNode valueExpr, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.COMPUTED_NAME_FIELD, diagnostics);
        this.openBracket = openBracket;
        this.fieldNameExpr = fieldNameExpr;
        this.closeBracket = closeBracket;
        this.colonToken = colonToken;
        this.valueExpr = valueExpr;
        this.addChildren(openBracket, fieldNameExpr, closeBracket, colonToken, valueExpr);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STComputedNameFieldNode(this.openBracket, this.fieldNameExpr, this.closeBracket, this.colonToken, this.valueExpr, diagnostics);
    }

    public STComputedNameFieldNode modify(STNode openBracket, STNode fieldNameExpr, STNode closeBracket, STNode colonToken, STNode valueExpr) {
        if (this.checkForReferenceEquality(openBracket, fieldNameExpr, closeBracket, colonToken, valueExpr)) {
            return this;
        }
        return new STComputedNameFieldNode(openBracket, fieldNameExpr, closeBracket, colonToken, valueExpr, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ComputedNameFieldNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

