/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.ContinueStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STContinueStatementNode
extends STStatementNode {
    public final STNode continueToken;
    public final STNode semicolonToken;

    STContinueStatementNode(STNode continueToken, STNode semicolonToken) {
        this(continueToken, semicolonToken, Collections.emptyList());
    }

    STContinueStatementNode(STNode continueToken, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.CONTINUE_STATEMENT, diagnostics);
        this.continueToken = continueToken;
        this.semicolonToken = semicolonToken;
        this.addChildren(continueToken, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STContinueStatementNode(this.continueToken, this.semicolonToken, diagnostics);
    }

    public STContinueStatementNode modify(STNode continueToken, STNode semicolonToken) {
        if (this.checkForReferenceEquality(continueToken, semicolonToken)) {
            return this;
        }
        return new STContinueStatementNode(continueToken, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ContinueStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

