/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STParameterNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STDefaultableParameterNode
extends STParameterNode {
    public final STNode annotations;
    public final STNode typeName;
    public final STNode paramName;
    public final STNode equalsToken;
    public final STNode expression;

    STDefaultableParameterNode(STNode annotations, STNode typeName, STNode paramName, STNode equalsToken, STNode expression) {
        this(annotations, typeName, paramName, equalsToken, expression, Collections.emptyList());
    }

    STDefaultableParameterNode(STNode annotations, STNode typeName, STNode paramName, STNode equalsToken, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.DEFAULTABLE_PARAM, diagnostics);
        this.annotations = annotations;
        this.typeName = typeName;
        this.paramName = paramName;
        this.equalsToken = equalsToken;
        this.expression = expression;
        this.addChildren(annotations, typeName, paramName, equalsToken, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STDefaultableParameterNode(this.annotations, this.typeName, this.paramName, this.equalsToken, this.expression, diagnostics);
    }

    public STDefaultableParameterNode modify(STNode annotations, STNode typeName, STNode paramName, STNode equalsToken, STNode expression) {
        if (this.checkForReferenceEquality(annotations, typeName, paramName, equalsToken, expression)) {
            return this;
        }
        return new STDefaultableParameterNode(annotations, typeName, paramName, equalsToken, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new DefaultableParameterNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

