/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STModuleMemberDeclarationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STEnumDeclarationNode
extends STModuleMemberDeclarationNode {
    public final STNode metadata;
    public final STNode qualifier;
    public final STNode enumKeywordToken;
    public final STNode identifier;
    public final STNode openBraceToken;
    public final STNode enumMemberList;
    public final STNode closeBraceToken;

    STEnumDeclarationNode(STNode metadata, STNode qualifier, STNode enumKeywordToken, STNode identifier, STNode openBraceToken, STNode enumMemberList, STNode closeBraceToken) {
        this(metadata, qualifier, enumKeywordToken, identifier, openBraceToken, enumMemberList, closeBraceToken, Collections.emptyList());
    }

    STEnumDeclarationNode(STNode metadata, STNode qualifier, STNode enumKeywordToken, STNode identifier, STNode openBraceToken, STNode enumMemberList, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ENUM_DECLARATION, diagnostics);
        this.metadata = metadata;
        this.qualifier = qualifier;
        this.enumKeywordToken = enumKeywordToken;
        this.identifier = identifier;
        this.openBraceToken = openBraceToken;
        this.enumMemberList = enumMemberList;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(metadata, qualifier, enumKeywordToken, identifier, openBraceToken, enumMemberList, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STEnumDeclarationNode(this.metadata, this.qualifier, this.enumKeywordToken, this.identifier, this.openBraceToken, this.enumMemberList, this.closeBraceToken, diagnostics);
    }

    public STEnumDeclarationNode modify(STNode metadata, STNode qualifier, STNode enumKeywordToken, STNode identifier, STNode openBraceToken, STNode enumMemberList, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(metadata, qualifier, enumKeywordToken, identifier, openBraceToken, enumMemberList, closeBraceToken)) {
            return this;
        }
        return new STEnumDeclarationNode(metadata, qualifier, enumKeywordToken, identifier, openBraceToken, enumMemberList, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new EnumDeclarationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

