/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STExpressionStatementNode
extends STStatementNode {
    public final STNode expression;
    public final STNode semicolonToken;

    STExpressionStatementNode(SyntaxKind kind, STNode expression, STNode semicolonToken) {
        this(kind, expression, semicolonToken, Collections.emptyList());
    }

    STExpressionStatementNode(SyntaxKind kind, STNode expression, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(kind, diagnostics);
        this.expression = expression;
        this.semicolonToken = semicolonToken;
        this.addChildren(expression, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STExpressionStatementNode(this.kind, this.expression, this.semicolonToken, diagnostics);
    }

    public STExpressionStatementNode modify(SyntaxKind kind, STNode expression, STNode semicolonToken) {
        if (this.checkForReferenceEquality(expression, semicolonToken)) {
            return this;
        }
        return new STExpressionStatementNode(kind, expression, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ExpressionStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

