/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STImportDeclarationNode
extends STNode {
    public final STNode importKeyword;
    public final STNode orgName;
    public final STNode moduleName;
    public final STNode prefix;
    public final STNode semicolon;

    STImportDeclarationNode(STNode importKeyword, STNode orgName, STNode moduleName, STNode prefix, STNode semicolon) {
        this(importKeyword, orgName, moduleName, prefix, semicolon, Collections.emptyList());
    }

    STImportDeclarationNode(STNode importKeyword, STNode orgName, STNode moduleName, STNode prefix, STNode semicolon, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.IMPORT_DECLARATION, diagnostics);
        this.importKeyword = importKeyword;
        this.orgName = orgName;
        this.moduleName = moduleName;
        this.prefix = prefix;
        this.semicolon = semicolon;
        this.addChildren(importKeyword, orgName, moduleName, prefix, semicolon);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STImportDeclarationNode(this.importKeyword, this.orgName, this.moduleName, this.prefix, this.semicolon, diagnostics);
    }

    public STImportDeclarationNode modify(STNode importKeyword, STNode orgName, STNode moduleName, STNode prefix, STNode semicolon) {
        if (this.checkForReferenceEquality(importKeyword, orgName, moduleName, prefix, semicolon)) {
            return this;
        }
        return new STImportDeclarationNode(importKeyword, orgName, moduleName, prefix, semicolon, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ImportDeclarationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

