/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STIntersectionTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode leftTypeDesc;
    public final STNode bitwiseAndToken;
    public final STNode rightTypeDesc;

    STIntersectionTypeDescriptorNode(STNode leftTypeDesc, STNode bitwiseAndToken, STNode rightTypeDesc) {
        this(leftTypeDesc, bitwiseAndToken, rightTypeDesc, Collections.emptyList());
    }

    STIntersectionTypeDescriptorNode(STNode leftTypeDesc, STNode bitwiseAndToken, STNode rightTypeDesc, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.INTERSECTION_TYPE_DESC, diagnostics);
        this.leftTypeDesc = leftTypeDesc;
        this.bitwiseAndToken = bitwiseAndToken;
        this.rightTypeDesc = rightTypeDesc;
        this.addChildren(leftTypeDesc, bitwiseAndToken, rightTypeDesc);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STIntersectionTypeDescriptorNode(this.leftTypeDesc, this.bitwiseAndToken, this.rightTypeDesc, diagnostics);
    }

    public STIntersectionTypeDescriptorNode modify(STNode leftTypeDesc, STNode bitwiseAndToken, STNode rightTypeDesc) {
        if (this.checkForReferenceEquality(leftTypeDesc, bitwiseAndToken, rightTypeDesc)) {
            return this;
        }
        return new STIntersectionTypeDescriptorNode(leftTypeDesc, bitwiseAndToken, rightTypeDesc, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new IntersectionTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

