/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STLetVariableDeclarationNode
extends STNode {
    public final STNode annotations;
    public final STNode typedBindingPattern;
    public final STNode equalsToken;
    public final STNode expression;

    STLetVariableDeclarationNode(STNode annotations, STNode typedBindingPattern, STNode equalsToken, STNode expression) {
        this(annotations, typedBindingPattern, equalsToken, expression, Collections.emptyList());
    }

    STLetVariableDeclarationNode(STNode annotations, STNode typedBindingPattern, STNode equalsToken, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LET_VAR_DECL, diagnostics);
        this.annotations = annotations;
        this.typedBindingPattern = typedBindingPattern;
        this.equalsToken = equalsToken;
        this.expression = expression;
        this.addChildren(annotations, typedBindingPattern, equalsToken, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STLetVariableDeclarationNode(this.annotations, this.typedBindingPattern, this.equalsToken, this.expression, diagnostics);
    }

    public STLetVariableDeclarationNode modify(STNode annotations, STNode typedBindingPattern, STNode equalsToken, STNode expression) {
        if (this.checkForReferenceEquality(annotations, typedBindingPattern, equalsToken, expression)) {
            return this;
        }
        return new STLetVariableDeclarationNode(annotations, typedBindingPattern, equalsToken, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new LetVariableDeclarationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

