/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STIntermediateClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.LimitClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STLimitClauseNode
extends STIntermediateClauseNode {
    public final STNode limitKeyword;
    public final STNode expression;

    STLimitClauseNode(STNode limitKeyword, STNode expression) {
        this(limitKeyword, expression, Collections.emptyList());
    }

    STLimitClauseNode(STNode limitKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LIMIT_CLAUSE, diagnostics);
        this.limitKeyword = limitKeyword;
        this.expression = expression;
        this.addChildren(limitKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STLimitClauseNode(this.limitKeyword, this.expression, diagnostics);
    }

    public STLimitClauseNode modify(STNode limitKeyword, STNode expression) {
        if (this.checkForReferenceEquality(limitKeyword, expression)) {
            return this;
        }
        return new STLimitClauseNode(limitKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new LimitClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

