/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ListMatchPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STListMatchPatternNode
extends STNode {
    public final STNode openBracket;
    public final STNode matchPatterns;
    public final STNode restMatchPattern;
    public final STNode closeBracket;

    STListMatchPatternNode(STNode openBracket, STNode matchPatterns, STNode restMatchPattern, STNode closeBracket) {
        this(openBracket, matchPatterns, restMatchPattern, closeBracket, Collections.emptyList());
    }

    STListMatchPatternNode(STNode openBracket, STNode matchPatterns, STNode restMatchPattern, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LIST_MATCH_PATTERN, diagnostics);
        this.openBracket = openBracket;
        this.matchPatterns = matchPatterns;
        this.restMatchPattern = restMatchPattern;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, matchPatterns, restMatchPattern, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STListMatchPatternNode(this.openBracket, this.matchPatterns, this.restMatchPattern, this.closeBracket, diagnostics);
    }

    public STListMatchPatternNode modify(STNode openBracket, STNode matchPatterns, STNode restMatchPattern, STNode closeBracket) {
        if (this.checkForReferenceEquality(openBracket, matchPatterns, restMatchPattern, closeBracket)) {
            return this;
        }
        return new STListMatchPatternNode(openBracket, matchPatterns, restMatchPattern, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ListMatchPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

