/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMappingConstructorExpressionNode
extends STExpressionNode {
    public final STNode openBrace;
    public final STNode fields;
    public final STNode closeBrace;

    STMappingConstructorExpressionNode(STNode openBrace, STNode fields, STNode closeBrace) {
        this(openBrace, fields, closeBrace, Collections.emptyList());
    }

    STMappingConstructorExpressionNode(STNode openBrace, STNode fields, STNode closeBrace, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MAPPING_CONSTRUCTOR, diagnostics);
        this.openBrace = openBrace;
        this.fields = fields;
        this.closeBrace = closeBrace;
        this.addChildren(openBrace, fields, closeBrace);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMappingConstructorExpressionNode(this.openBrace, this.fields, this.closeBrace, diagnostics);
    }

    public STMappingConstructorExpressionNode modify(STNode openBrace, STNode fields, STNode closeBrace) {
        if (this.checkForReferenceEquality(openBrace, fields, closeBrace)) {
            return this;
        }
        return new STMappingConstructorExpressionNode(openBrace, fields, closeBrace, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MappingConstructorExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

