/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STNamedWorkerDeclarationNode
extends STNode {
    public final STNode annotations;
    public final STNode transactionalKeyword;
    public final STNode workerKeyword;
    public final STNode workerName;
    public final STNode returnTypeDesc;
    public final STNode workerBody;

    STNamedWorkerDeclarationNode(STNode annotations, STNode transactionalKeyword, STNode workerKeyword, STNode workerName, STNode returnTypeDesc, STNode workerBody) {
        this(annotations, transactionalKeyword, workerKeyword, workerName, returnTypeDesc, workerBody, Collections.emptyList());
    }

    STNamedWorkerDeclarationNode(STNode annotations, STNode transactionalKeyword, STNode workerKeyword, STNode workerName, STNode returnTypeDesc, STNode workerBody, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.NAMED_WORKER_DECLARATION, diagnostics);
        this.annotations = annotations;
        this.transactionalKeyword = transactionalKeyword;
        this.workerKeyword = workerKeyword;
        this.workerName = workerName;
        this.returnTypeDesc = returnTypeDesc;
        this.workerBody = workerBody;
        this.addChildren(annotations, transactionalKeyword, workerKeyword, workerName, returnTypeDesc, workerBody);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STNamedWorkerDeclarationNode(this.annotations, this.transactionalKeyword, this.workerKeyword, this.workerName, this.returnTypeDesc, this.workerBody, diagnostics);
    }

    public STNamedWorkerDeclarationNode modify(STNode annotations, STNode transactionalKeyword, STNode workerKeyword, STNode workerName, STNode returnTypeDesc, STNode workerBody) {
        if (this.checkForReferenceEquality(annotations, transactionalKeyword, workerKeyword, workerName, returnTypeDesc, workerBody)) {
            return this;
        }
        return new STNamedWorkerDeclarationNode(annotations, transactionalKeyword, workerKeyword, workerName, returnTypeDesc, workerBody, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new NamedWorkerDeclarationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

