/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterizedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STParameterizedTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode parameterizedType;
    public final STNode typeParameter;

    STParameterizedTypeDescriptorNode(STNode parameterizedType, STNode typeParameter) {
        this(parameterizedType, typeParameter, Collections.emptyList());
    }

    STParameterizedTypeDescriptorNode(STNode parameterizedType, STNode typeParameter, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.PARAMETERIZED_TYPE_DESC, diagnostics);
        this.parameterizedType = parameterizedType;
        this.typeParameter = typeParameter;
        this.addChildren(parameterizedType, typeParameter);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STParameterizedTypeDescriptorNode(this.parameterizedType, this.typeParameter, diagnostics);
    }

    public STParameterizedTypeDescriptorNode modify(STNode parameterizedType, STNode typeParameter) {
        if (this.checkForReferenceEquality(parameterizedType, typeParameter)) {
            return this;
        }
        return new STParameterizedTypeDescriptorNode(parameterizedType, typeParameter, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ParameterizedTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

