/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReceiveFieldsNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReceiveFieldsNode
extends STNode {
    public final STNode openBrace;
    public final STNode receiveFields;
    public final STNode closeBrace;

    STReceiveFieldsNode(STNode openBrace, STNode receiveFields, STNode closeBrace) {
        this(openBrace, receiveFields, closeBrace, Collections.emptyList());
    }

    STReceiveFieldsNode(STNode openBrace, STNode receiveFields, STNode closeBrace, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RECEIVE_FIELDS, diagnostics);
        this.openBrace = openBrace;
        this.receiveFields = receiveFields;
        this.closeBrace = closeBrace;
        this.addChildren(openBrace, receiveFields, closeBrace);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReceiveFieldsNode(this.openBrace, this.receiveFields, this.closeBrace, diagnostics);
    }

    public STReceiveFieldsNode modify(STNode openBrace, STNode receiveFields, STNode closeBrace) {
        if (this.checkForReferenceEquality(openBrace, receiveFields, closeBrace)) {
            return this;
        }
        return new STReceiveFieldsNode(openBrace, receiveFields, closeBrace, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReceiveFieldsNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

