/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRequiredParameterNode
extends STParameterNode {
    public final STNode annotations;
    public final STNode asteriskToken;
    public final STNode typeName;
    public final STNode paramName;

    STRequiredParameterNode(SyntaxKind kind, STNode annotations, STNode asteriskToken, STNode typeName, STNode paramName) {
        this(kind, annotations, asteriskToken, typeName, paramName, Collections.emptyList());
    }

    STRequiredParameterNode(SyntaxKind kind, STNode annotations, STNode asteriskToken, STNode typeName, STNode paramName, Collection<STNodeDiagnostic> diagnostics) {
        super(kind, diagnostics);
        this.annotations = annotations;
        this.asteriskToken = asteriskToken;
        this.typeName = typeName;
        this.paramName = paramName;
        this.addChildren(annotations, asteriskToken, typeName, paramName);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRequiredParameterNode(this.kind, this.annotations, this.asteriskToken, this.typeName, this.paramName, diagnostics);
    }

    public STRequiredParameterNode modify(SyntaxKind kind, STNode annotations, STNode asteriskToken, STNode typeName, STNode paramName) {
        if (this.checkForReferenceEquality(annotations, asteriskToken, typeName, paramName)) {
            return this;
        }
        return new STRequiredParameterNode(kind, annotations, asteriskToken, typeName, paramName, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RequiredParameterNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

