/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StartActionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STStartActionNode
extends STExpressionNode {
    public final STNode annotations;
    public final STNode startKeyword;
    public final STNode expression;

    STStartActionNode(STNode annotations, STNode startKeyword, STNode expression) {
        this(annotations, startKeyword, expression, Collections.emptyList());
    }

    STStartActionNode(STNode annotations, STNode startKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.START_ACTION, diagnostics);
        this.annotations = annotations;
        this.startKeyword = startKeyword;
        this.expression = expression;
        this.addChildren(annotations, startKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STStartActionNode(this.annotations, this.startKeyword, this.expression, diagnostics);
    }

    public STStartActionNode modify(STNode annotations, STNode startKeyword, STNode expression) {
        if (this.checkForReferenceEquality(annotations, startKeyword, expression)) {
            return this;
        }
        return new STStartActionNode(annotations, startKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new StartActionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

