/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLNamePatternChainingNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLNamePatternChainingNode
extends STNode {
    public final STNode startToken;
    public final STNode xmlNamePattern;
    public final STNode gtToken;

    STXMLNamePatternChainingNode(STNode startToken, STNode xmlNamePattern, STNode gtToken) {
        this(startToken, xmlNamePattern, gtToken, Collections.emptyList());
    }

    STXMLNamePatternChainingNode(STNode startToken, STNode xmlNamePattern, STNode gtToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_NAME_PATTERN_CHAIN, diagnostics);
        this.startToken = startToken;
        this.xmlNamePattern = xmlNamePattern;
        this.gtToken = gtToken;
        this.addChildren(startToken, xmlNamePattern, gtToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLNamePatternChainingNode(this.startToken, this.xmlNamePattern, this.gtToken, diagnostics);
    }

    public STXMLNamePatternChainingNode modify(STNode startToken, STNode xmlNamePattern, STNode gtToken) {
        if (this.checkForReferenceEquality(startToken, xmlNamePattern, gtToken)) {
            return this;
        }
        return new STXMLNamePatternChainingNode(startToken, xmlNamePattern, gtToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLNamePatternChainingNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

