/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class BinaryExpressionNode
extends ExpressionNode {
    public BinaryExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node lhsExpr() {
        return this.childInBucket(0);
    }

    public Token operator() {
        return (Token)this.childInBucket(1);
    }

    public Node rhsExpr() {
        return this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"lhsExpr", "operator", "rhsExpr"};
    }

    public BinaryExpressionNode modify(SyntaxKind kind, Node lhsExpr, Token operator, Node rhsExpr) {
        if (this.checkForReferenceEquality(lhsExpr, operator, rhsExpr)) {
            return this;
        }
        return NodeFactory.createBinaryExpressionNode(kind, lhsExpr, operator, rhsExpr);
    }

    public BinaryExpressionNodeModifier modify() {
        return new BinaryExpressionNodeModifier(this);
    }

    public static class BinaryExpressionNodeModifier {
        private final BinaryExpressionNode oldNode;
        private Node lhsExpr;
        private Token operator;
        private Node rhsExpr;

        public BinaryExpressionNodeModifier(BinaryExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.lhsExpr = oldNode.lhsExpr();
            this.operator = oldNode.operator();
            this.rhsExpr = oldNode.rhsExpr();
        }

        public BinaryExpressionNodeModifier withLhsExpr(Node lhsExpr) {
            Objects.requireNonNull(lhsExpr, "lhsExpr must not be null");
            this.lhsExpr = lhsExpr;
            return this;
        }

        public BinaryExpressionNodeModifier withOperator(Token operator) {
            Objects.requireNonNull(operator, "operator must not be null");
            this.operator = operator;
            return this;
        }

        public BinaryExpressionNodeModifier withRhsExpr(Node rhsExpr) {
            Objects.requireNonNull(rhsExpr, "rhsExpr must not be null");
            this.rhsExpr = rhsExpr;
            return this;
        }

        public BinaryExpressionNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.lhsExpr, this.operator, this.rhsExpr);
        }
    }
}

