/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class EnumMemberNode
extends NonTerminalNode {
    public EnumMemberNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public IdentifierToken identifier() {
        return (IdentifierToken)this.childInBucket(1);
    }

    public Optional<Token> equalToken() {
        return this.optionalChildInBucket(2);
    }

    public Optional<ExpressionNode> constExprNode() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "identifier", "equalToken", "constExprNode"};
    }

    public EnumMemberNode modify(MetadataNode metadata, IdentifierToken identifier, Token equalToken, ExpressionNode constExprNode) {
        if (this.checkForReferenceEquality(metadata, identifier, equalToken, constExprNode)) {
            return this;
        }
        return NodeFactory.createEnumMemberNode(metadata, identifier, equalToken, constExprNode);
    }

    public EnumMemberNodeModifier modify() {
        return new EnumMemberNodeModifier(this);
    }

    public static class EnumMemberNodeModifier {
        private final EnumMemberNode oldNode;
        private MetadataNode metadata;
        private IdentifierToken identifier;
        private Token equalToken;
        private ExpressionNode constExprNode;

        public EnumMemberNodeModifier(EnumMemberNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.identifier = oldNode.identifier();
            this.equalToken = oldNode.equalToken().orElse(null);
            this.constExprNode = oldNode.constExprNode().orElse(null);
        }

        public EnumMemberNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public EnumMemberNodeModifier withIdentifier(IdentifierToken identifier) {
            Objects.requireNonNull(identifier, "identifier must not be null");
            this.identifier = identifier;
            return this;
        }

        public EnumMemberNodeModifier withEqualToken(Token equalToken) {
            this.equalToken = equalToken;
            return this;
        }

        public EnumMemberNodeModifier withConstExprNode(ExpressionNode constExprNode) {
            this.constExprNode = constExprNode;
            return this;
        }

        public EnumMemberNode apply() {
            return this.oldNode.modify(this.metadata, this.identifier, this.equalToken, this.constExprNode);
        }
    }
}

