/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ErrorMatchPatternNode
extends NonTerminalNode {
    public ErrorMatchPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token errorKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<NameReferenceNode> typeReference() {
        return this.optionalChildInBucket(1);
    }

    public Token openParenthesisToken() {
        return (Token)this.childInBucket(2);
    }

    public SeparatedNodeList<Node> argListMatchPatternNode() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(3));
    }

    public Token closeParenthesisToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"errorKeyword", "typeReference", "openParenthesisToken", "argListMatchPatternNode", "closeParenthesisToken"};
    }

    public ErrorMatchPatternNode modify(Token errorKeyword, NameReferenceNode typeReference, Token openParenthesisToken, SeparatedNodeList<Node> argListMatchPatternNode, Token closeParenthesisToken) {
        if (this.checkForReferenceEquality(errorKeyword, typeReference, openParenthesisToken, argListMatchPatternNode.underlyingListNode(), closeParenthesisToken)) {
            return this;
        }
        return NodeFactory.createErrorMatchPatternNode(errorKeyword, typeReference, openParenthesisToken, argListMatchPatternNode, closeParenthesisToken);
    }

    public ErrorMatchPatternNodeModifier modify() {
        return new ErrorMatchPatternNodeModifier(this);
    }

    public static class ErrorMatchPatternNodeModifier {
        private final ErrorMatchPatternNode oldNode;
        private Token errorKeyword;
        private NameReferenceNode typeReference;
        private Token openParenthesisToken;
        private SeparatedNodeList<Node> argListMatchPatternNode;
        private Token closeParenthesisToken;

        public ErrorMatchPatternNodeModifier(ErrorMatchPatternNode oldNode) {
            this.oldNode = oldNode;
            this.errorKeyword = oldNode.errorKeyword();
            this.typeReference = oldNode.typeReference().orElse(null);
            this.openParenthesisToken = oldNode.openParenthesisToken();
            this.argListMatchPatternNode = oldNode.argListMatchPatternNode();
            this.closeParenthesisToken = oldNode.closeParenthesisToken();
        }

        public ErrorMatchPatternNodeModifier withErrorKeyword(Token errorKeyword) {
            Objects.requireNonNull(errorKeyword, "errorKeyword must not be null");
            this.errorKeyword = errorKeyword;
            return this;
        }

        public ErrorMatchPatternNodeModifier withTypeReference(NameReferenceNode typeReference) {
            this.typeReference = typeReference;
            return this;
        }

        public ErrorMatchPatternNodeModifier withOpenParenthesisToken(Token openParenthesisToken) {
            Objects.requireNonNull(openParenthesisToken, "openParenthesisToken must not be null");
            this.openParenthesisToken = openParenthesisToken;
            return this;
        }

        public ErrorMatchPatternNodeModifier withArgListMatchPatternNode(SeparatedNodeList<Node> argListMatchPatternNode) {
            Objects.requireNonNull(argListMatchPatternNode, "argListMatchPatternNode must not be null");
            this.argListMatchPatternNode = argListMatchPatternNode;
            return this;
        }

        public ErrorMatchPatternNodeModifier withCloseParenthesisToken(Token closeParenthesisToken) {
            Objects.requireNonNull(closeParenthesisToken, "closeParenthesisToken must not be null");
            this.closeParenthesisToken = closeParenthesisToken;
            return this;
        }

        public ErrorMatchPatternNode apply() {
            return this.oldNode.modify(this.errorKeyword, this.typeReference, this.openParenthesisToken, this.argListMatchPatternNode, this.closeParenthesisToken);
        }
    }
}

