/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ExpressionFunctionBodyNode
extends FunctionBodyNode {
    public ExpressionFunctionBodyNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token rightDoubleArrow() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Optional<Token> semicolon() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"rightDoubleArrow", "expression", "semicolon"};
    }

    public ExpressionFunctionBodyNode modify(Token rightDoubleArrow, ExpressionNode expression, Token semicolon) {
        if (this.checkForReferenceEquality(rightDoubleArrow, expression, semicolon)) {
            return this;
        }
        return NodeFactory.createExpressionFunctionBodyNode(rightDoubleArrow, expression, semicolon);
    }

    public ExpressionFunctionBodyNodeModifier modify() {
        return new ExpressionFunctionBodyNodeModifier(this);
    }

    public static class ExpressionFunctionBodyNodeModifier {
        private final ExpressionFunctionBodyNode oldNode;
        private Token rightDoubleArrow;
        private ExpressionNode expression;
        private Token semicolon;

        public ExpressionFunctionBodyNodeModifier(ExpressionFunctionBodyNode oldNode) {
            this.oldNode = oldNode;
            this.rightDoubleArrow = oldNode.rightDoubleArrow();
            this.expression = oldNode.expression();
            this.semicolon = oldNode.semicolon().orElse(null);
        }

        public ExpressionFunctionBodyNodeModifier withRightDoubleArrow(Token rightDoubleArrow) {
            Objects.requireNonNull(rightDoubleArrow, "rightDoubleArrow must not be null");
            this.rightDoubleArrow = rightDoubleArrow;
            return this;
        }

        public ExpressionFunctionBodyNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public ExpressionFunctionBodyNodeModifier withSemicolon(Token semicolon) {
            this.semicolon = semicolon;
            return this;
        }

        public ExpressionFunctionBodyNode apply() {
            return this.oldNode.modify(this.rightDoubleArrow, this.expression, this.semicolon);
        }
    }
}

