/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class FlushActionNode
extends ExpressionNode {
    public FlushActionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token flushKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<NameReferenceNode> peerWorker() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"flushKeyword", "peerWorker"};
    }

    public FlushActionNode modify(Token flushKeyword, NameReferenceNode peerWorker) {
        if (this.checkForReferenceEquality(flushKeyword, peerWorker)) {
            return this;
        }
        return NodeFactory.createFlushActionNode(flushKeyword, peerWorker);
    }

    public FlushActionNodeModifier modify() {
        return new FlushActionNodeModifier(this);
    }

    public static class FlushActionNodeModifier {
        private final FlushActionNode oldNode;
        private Token flushKeyword;
        private NameReferenceNode peerWorker;

        public FlushActionNodeModifier(FlushActionNode oldNode) {
            this.oldNode = oldNode;
            this.flushKeyword = oldNode.flushKeyword();
            this.peerWorker = oldNode.peerWorker().orElse(null);
        }

        public FlushActionNodeModifier withFlushKeyword(Token flushKeyword) {
            Objects.requireNonNull(flushKeyword, "flushKeyword must not be null");
            this.flushKeyword = flushKeyword;
            return this;
        }

        public FlushActionNodeModifier withPeerWorker(NameReferenceNode peerWorker) {
            this.peerWorker = peerWorker;
            return this;
        }

        public FlushActionNode apply() {
            return this.oldNode.modify(this.flushKeyword, this.peerWorker);
        }
    }
}

