/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ImportDeclarationNode
extends NonTerminalNode {
    public ImportDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token importKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<ImportOrgNameNode> orgName() {
        return this.optionalChildInBucket(1);
    }

    public SeparatedNodeList<IdentifierToken> moduleName() {
        return new SeparatedNodeList<IdentifierToken>((NonTerminalNode)this.childInBucket(2));
    }

    public Optional<ImportPrefixNode> prefix() {
        return this.optionalChildInBucket(3);
    }

    public Token semicolon() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"importKeyword", "orgName", "moduleName", "prefix", "semicolon"};
    }

    public ImportDeclarationNode modify(Token importKeyword, ImportOrgNameNode orgName, SeparatedNodeList<IdentifierToken> moduleName, ImportPrefixNode prefix, Token semicolon) {
        if (this.checkForReferenceEquality(importKeyword, orgName, moduleName.underlyingListNode(), prefix, semicolon)) {
            return this;
        }
        return NodeFactory.createImportDeclarationNode(importKeyword, orgName, moduleName, prefix, semicolon);
    }

    public ImportDeclarationNodeModifier modify() {
        return new ImportDeclarationNodeModifier(this);
    }

    public static class ImportDeclarationNodeModifier {
        private final ImportDeclarationNode oldNode;
        private Token importKeyword;
        private ImportOrgNameNode orgName;
        private SeparatedNodeList<IdentifierToken> moduleName;
        private ImportPrefixNode prefix;
        private Token semicolon;

        public ImportDeclarationNodeModifier(ImportDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.importKeyword = oldNode.importKeyword();
            this.orgName = oldNode.orgName().orElse(null);
            this.moduleName = oldNode.moduleName();
            this.prefix = oldNode.prefix().orElse(null);
            this.semicolon = oldNode.semicolon();
        }

        public ImportDeclarationNodeModifier withImportKeyword(Token importKeyword) {
            Objects.requireNonNull(importKeyword, "importKeyword must not be null");
            this.importKeyword = importKeyword;
            return this;
        }

        public ImportDeclarationNodeModifier withOrgName(ImportOrgNameNode orgName) {
            this.orgName = orgName;
            return this;
        }

        public ImportDeclarationNodeModifier withModuleName(SeparatedNodeList<IdentifierToken> moduleName) {
            Objects.requireNonNull(moduleName, "moduleName must not be null");
            this.moduleName = moduleName;
            return this;
        }

        public ImportDeclarationNodeModifier withPrefix(ImportPrefixNode prefix) {
            this.prefix = prefix;
            return this;
        }

        public ImportDeclarationNodeModifier withSemicolon(Token semicolon) {
            Objects.requireNonNull(semicolon, "semicolon must not be null");
            this.semicolon = semicolon;
            return this;
        }

        public ImportDeclarationNode apply() {
            return this.oldNode.modify(this.importKeyword, this.orgName, this.moduleName, this.prefix, this.semicolon);
        }
    }
}

