/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ImportPrefixNode
extends NonTerminalNode {
    public ImportPrefixNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token asKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token prefix() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"asKeyword", "prefix"};
    }

    public ImportPrefixNode modify(Token asKeyword, Token prefix) {
        if (this.checkForReferenceEquality(asKeyword, prefix)) {
            return this;
        }
        return NodeFactory.createImportPrefixNode(asKeyword, prefix);
    }

    public ImportPrefixNodeModifier modify() {
        return new ImportPrefixNodeModifier(this);
    }

    public static class ImportPrefixNodeModifier {
        private final ImportPrefixNode oldNode;
        private Token asKeyword;
        private Token prefix;

        public ImportPrefixNodeModifier(ImportPrefixNode oldNode) {
            this.oldNode = oldNode;
            this.asKeyword = oldNode.asKeyword();
            this.prefix = oldNode.prefix();
        }

        public ImportPrefixNodeModifier withAsKeyword(Token asKeyword) {
            Objects.requireNonNull(asKeyword, "asKeyword must not be null");
            this.asKeyword = asKeyword;
            return this;
        }

        public ImportPrefixNodeModifier withPrefix(Token prefix) {
            Objects.requireNonNull(prefix, "prefix must not be null");
            this.prefix = prefix;
            return this;
        }

        public ImportPrefixNode apply() {
            return this.oldNode.modify(this.asKeyword, this.prefix);
        }
    }
}

