/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLItemNode;
import java.util.Objects;

public class InterpolationNode
extends XMLItemNode {
    public InterpolationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token interpolationStartToken() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token interpolationEndToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"interpolationStartToken", "expression", "interpolationEndToken"};
    }

    public InterpolationNode modify(Token interpolationStartToken, ExpressionNode expression, Token interpolationEndToken) {
        if (this.checkForReferenceEquality(interpolationStartToken, expression, interpolationEndToken)) {
            return this;
        }
        return NodeFactory.createInterpolationNode(interpolationStartToken, expression, interpolationEndToken);
    }

    public InterpolationNodeModifier modify() {
        return new InterpolationNodeModifier(this);
    }

    public static class InterpolationNodeModifier {
        private final InterpolationNode oldNode;
        private Token interpolationStartToken;
        private ExpressionNode expression;
        private Token interpolationEndToken;

        public InterpolationNodeModifier(InterpolationNode oldNode) {
            this.oldNode = oldNode;
            this.interpolationStartToken = oldNode.interpolationStartToken();
            this.expression = oldNode.expression();
            this.interpolationEndToken = oldNode.interpolationEndToken();
        }

        public InterpolationNodeModifier withInterpolationStartToken(Token interpolationStartToken) {
            Objects.requireNonNull(interpolationStartToken, "interpolationStartToken must not be null");
            this.interpolationStartToken = interpolationStartToken;
            return this;
        }

        public InterpolationNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public InterpolationNodeModifier withInterpolationEndToken(Token interpolationEndToken) {
            Objects.requireNonNull(interpolationEndToken, "interpolationEndToken must not be null");
            this.interpolationEndToken = interpolationEndToken;
            return this;
        }

        public InterpolationNode apply() {
            return this.oldNode.modify(this.interpolationStartToken, this.expression, this.interpolationEndToken);
        }
    }
}

