/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ListBindingPatternNode
extends BindingPatternNode {
    public ListBindingPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<BindingPatternNode> bindingPatterns() {
        return new SeparatedNodeList<BindingPatternNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "bindingPatterns", "closeBracket"};
    }

    public ListBindingPatternNode modify(Token openBracket, SeparatedNodeList<BindingPatternNode> bindingPatterns, Token closeBracket) {
        if (this.checkForReferenceEquality(openBracket, bindingPatterns.underlyingListNode(), closeBracket)) {
            return this;
        }
        return NodeFactory.createListBindingPatternNode(openBracket, bindingPatterns, closeBracket);
    }

    public ListBindingPatternNodeModifier modify() {
        return new ListBindingPatternNodeModifier(this);
    }

    public static class ListBindingPatternNodeModifier {
        private final ListBindingPatternNode oldNode;
        private Token openBracket;
        private SeparatedNodeList<BindingPatternNode> bindingPatterns;
        private Token closeBracket;

        public ListBindingPatternNodeModifier(ListBindingPatternNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.bindingPatterns = oldNode.bindingPatterns();
            this.closeBracket = oldNode.closeBracket();
        }

        public ListBindingPatternNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public ListBindingPatternNodeModifier withBindingPatterns(SeparatedNodeList<BindingPatternNode> bindingPatterns) {
            Objects.requireNonNull(bindingPatterns, "bindingPatterns must not be null");
            this.bindingPatterns = bindingPatterns;
            return this;
        }

        public ListBindingPatternNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public ListBindingPatternNode apply() {
            return this.oldNode.modify(this.openBracket, this.bindingPatterns, this.closeBracket);
        }
    }
}

