/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class LockStatementNode
extends StatementNode {
    public LockStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token lockKeyword() {
        return (Token)this.childInBucket(0);
    }

    public StatementNode blockStatement() {
        return (StatementNode)this.childInBucket(1);
    }

    public Optional<OnFailClauseNode> onFailClause() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"lockKeyword", "blockStatement", "onFailClause"};
    }

    public LockStatementNode modify(Token lockKeyword, StatementNode blockStatement, OnFailClauseNode onFailClause) {
        if (this.checkForReferenceEquality(lockKeyword, blockStatement, onFailClause)) {
            return this;
        }
        return NodeFactory.createLockStatementNode(lockKeyword, blockStatement, onFailClause);
    }

    public LockStatementNodeModifier modify() {
        return new LockStatementNodeModifier(this);
    }

    public static class LockStatementNodeModifier {
        private final LockStatementNode oldNode;
        private Token lockKeyword;
        private StatementNode blockStatement;
        private OnFailClauseNode onFailClause;

        public LockStatementNodeModifier(LockStatementNode oldNode) {
            this.oldNode = oldNode;
            this.lockKeyword = oldNode.lockKeyword();
            this.blockStatement = oldNode.blockStatement();
            this.onFailClause = oldNode.onFailClause().orElse(null);
        }

        public LockStatementNodeModifier withLockKeyword(Token lockKeyword) {
            Objects.requireNonNull(lockKeyword, "lockKeyword must not be null");
            this.lockKeyword = lockKeyword;
            return this;
        }

        public LockStatementNodeModifier withBlockStatement(StatementNode blockStatement) {
            Objects.requireNonNull(blockStatement, "blockStatement must not be null");
            this.blockStatement = blockStatement;
            return this;
        }

        public LockStatementNodeModifier withOnFailClause(OnFailClauseNode onFailClause) {
            this.onFailClause = onFailClause;
            return this;
        }

        public LockStatementNode apply() {
            return this.oldNode.modify(this.lockKeyword, this.blockStatement, this.onFailClause);
        }
    }
}

