/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class MatchGuardNode
extends NonTerminalNode {
    public MatchGuardNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ifKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ifKeyword", "expression"};
    }

    public MatchGuardNode modify(Token ifKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(ifKeyword, expression)) {
            return this;
        }
        return NodeFactory.createMatchGuardNode(ifKeyword, expression);
    }

    public MatchGuardNodeModifier modify() {
        return new MatchGuardNodeModifier(this);
    }

    public static class MatchGuardNodeModifier {
        private final MatchGuardNode oldNode;
        private Token ifKeyword;
        private ExpressionNode expression;

        public MatchGuardNodeModifier(MatchGuardNode oldNode) {
            this.oldNode = oldNode;
            this.ifKeyword = oldNode.ifKeyword();
            this.expression = oldNode.expression();
        }

        public MatchGuardNodeModifier withIfKeyword(Token ifKeyword) {
            Objects.requireNonNull(ifKeyword, "ifKeyword must not be null");
            this.ifKeyword = ifKeyword;
            return this;
        }

        public MatchGuardNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public MatchGuardNode apply() {
            return this.oldNode.modify(this.ifKeyword, this.expression);
        }
    }
}

