/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STMinutiae;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeList;
import io.ballerina.compiler.internal.syntax.NodeListUtils;
import io.ballerina.compiler.internal.syntax.SyntaxUtils;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MinutiaeList
implements Iterable<Minutiae> {
    private final Token token;
    private final STNodeList internalListNode;
    private final int position;
    private final int size;
    private final Minutiae[] minutiaeNodes;

    MinutiaeList(Token token, STNode internalMinutiae, int position) {
        if (!NodeListUtils.isSTNodeList(internalMinutiae)) {
            throw new IllegalArgumentException("An STNodeList instance is expected");
        }
        this.internalListNode = (STNodeList)internalMinutiae;
        this.token = token;
        this.position = position;
        this.size = this.getMinutiaeCount(internalMinutiae);
        this.minutiaeNodes = this.loadMinutiaeNodes(internalMinutiae, this.size, position);
    }

    public Minutiae get(int index) {
        NodeListUtils.rangeCheck(index, this.size);
        return this.minutiaeNodes[index];
    }

    public MinutiaeList add(Minutiae minutiae) {
        Objects.requireNonNull(minutiae, "minutiae should not be null");
        return new MinutiaeList(this.token, this.internalListNode.add(minutiae.internalNode()), this.position);
    }

    public MinutiaeList add(int index, Minutiae minutiae) {
        Objects.requireNonNull(minutiae, "minutiae should not be null");
        NodeListUtils.rangeCheckForAdd(index, this.size);
        return new MinutiaeList(this.token, this.internalListNode.add(index, minutiae.internalNode()), this.position);
    }

    public MinutiaeList addAll(Collection<Minutiae> c) {
        if (c.isEmpty()) {
            return this;
        }
        List<STNode> stNodesToBeAdded = c.stream().map(minutiae -> Objects.requireNonNull(minutiae, "minutiae should not be null")).map(Minutiae::internalNode).collect(Collectors.toList());
        return new MinutiaeList(this.token, this.internalListNode.addAll(stNodesToBeAdded), this.position);
    }

    public MinutiaeList set(int index, Minutiae minutiae) {
        Objects.requireNonNull(minutiae, "minutiae should not be null");
        NodeListUtils.rangeCheck(index, this.size);
        if (this.minutiaeNodes[index] == minutiae) {
            return this;
        }
        return new MinutiaeList(this.token, this.internalListNode.set(index, minutiae.internalNode()), this.position);
    }

    public MinutiaeList remove(int index) {
        NodeListUtils.rangeCheck(index, this.size);
        return new MinutiaeList(this.token, this.internalListNode.remove(index), this.position);
    }

    public MinutiaeList remove(Minutiae minutiae) {
        Objects.requireNonNull(minutiae, "minutiae should not be null");
        for (int i = 0; i < this.minutiaeNodes.length; ++i) {
            if (minutiae != this.minutiaeNodes[i]) continue;
            return this.remove(i);
        }
        return this;
    }

    public MinutiaeList removeAll(Collection<Minutiae> c) {
        if (c.isEmpty()) {
            return this;
        }
        c.forEach(minutiae -> Objects.requireNonNull(minutiae, "minutiae should not be null"));
        ArrayList<STNode> toBeDeletedList = new ArrayList<STNode>();
        for (Minutiae minutiae2 : this.minutiaeNodes) {
            if (!c.contains(minutiae2)) continue;
            toBeDeletedList.add(minutiae2.internalNode());
        }
        return new MinutiaeList(this.token, this.internalListNode.removeAll(toBeDeletedList), this.position);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Minutiae> iterator() {
        return new Iterator<Minutiae>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < MinutiaeList.this.size;
            }

            @Override
            public Minutiae next() {
                return MinutiaeList.this.get(this.currentIndex++);
            }
        };
    }

    protected STNode internalNode() {
        return this.internalListNode;
    }

    private Minutiae[] loadMinutiaeNodes(STNode internalMinutiae, int size, int position) {
        if (size == 0) {
            return new Minutiae[0];
        }
        int index = 0;
        int minutiaeStartPos = position;
        Minutiae[] minutiaeNodes = new Minutiae[size];
        for (int bucket = 0; bucket < internalMinutiae.bucketCount(); ++bucket) {
            STNode node = internalMinutiae.childInBucket(bucket);
            if (!SyntaxUtils.isSTNodePresent(node)) continue;
            minutiaeNodes[index] = this.createMinutiae(node, minutiaeStartPos);
            ++index;
            minutiaeStartPos += node.widthWithMinutiae();
        }
        return minutiaeNodes;
    }

    private Minutiae createMinutiae(STNode internalMinutiae, int position) {
        return new Minutiae((STMinutiae)internalMinutiae, this.token, position);
    }

    private int getMinutiaeCount(STNode internalMinutiae) {
        for (int bucket = 0; bucket < internalMinutiae.bucketCount(); ++bucket) {
            STNode child = internalMinutiae.childInBucket(bucket);
            if (SyntaxUtils.isSTNodePresent(child)) continue;
            throw new IllegalStateException("No minutia nodes with 'null' values are allowed in MinutiaeList");
        }
        return internalMinutiae.bucketCount();
    }

    public String toString() {
        return this.internalListNode.toString();
    }
}

