/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class NamedArgMatchPatternNode
extends NonTerminalNode {
    public NamedArgMatchPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public IdentifierToken identifier() {
        return (IdentifierToken)this.childInBucket(0);
    }

    public Token equalToken() {
        return (Token)this.childInBucket(1);
    }

    public Node matchPattern() {
        return this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"identifier", "equalToken", "matchPattern"};
    }

    public NamedArgMatchPatternNode modify(IdentifierToken identifier, Token equalToken, Node matchPattern) {
        if (this.checkForReferenceEquality(identifier, equalToken, matchPattern)) {
            return this;
        }
        return NodeFactory.createNamedArgMatchPatternNode(identifier, equalToken, matchPattern);
    }

    public NamedArgMatchPatternNodeModifier modify() {
        return new NamedArgMatchPatternNodeModifier(this);
    }

    public static class NamedArgMatchPatternNodeModifier {
        private final NamedArgMatchPatternNode oldNode;
        private IdentifierToken identifier;
        private Token equalToken;
        private Node matchPattern;

        public NamedArgMatchPatternNodeModifier(NamedArgMatchPatternNode oldNode) {
            this.oldNode = oldNode;
            this.identifier = oldNode.identifier();
            this.equalToken = oldNode.equalToken();
            this.matchPattern = oldNode.matchPattern();
        }

        public NamedArgMatchPatternNodeModifier withIdentifier(IdentifierToken identifier) {
            Objects.requireNonNull(identifier, "identifier must not be null");
            this.identifier = identifier;
            return this;
        }

        public NamedArgMatchPatternNodeModifier withEqualToken(Token equalToken) {
            Objects.requireNonNull(equalToken, "equalToken must not be null");
            this.equalToken = equalToken;
            return this;
        }

        public NamedArgMatchPatternNodeModifier withMatchPattern(Node matchPattern) {
            Objects.requireNonNull(matchPattern, "matchPattern must not be null");
            this.matchPattern = matchPattern;
            return this;
        }

        public NamedArgMatchPatternNode apply() {
            return this.oldNode.modify(this.identifier, this.equalToken, this.matchPattern);
        }
    }
}

