/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class NilTypeDescriptorNode
extends TypeDescriptorNode {
    public NilTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(0);
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openParenToken", "closeParenToken"};
    }

    public NilTypeDescriptorNode modify(Token openParenToken, Token closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, closeParenToken)) {
            return this;
        }
        return NodeFactory.createNilTypeDescriptorNode(openParenToken, closeParenToken);
    }

    public NilTypeDescriptorNodeModifier modify() {
        return new NilTypeDescriptorNodeModifier(this);
    }

    public static class NilTypeDescriptorNodeModifier {
        private final NilTypeDescriptorNode oldNode;
        private Token openParenToken;
        private Token closeParenToken;

        public NilTypeDescriptorNodeModifier(NilTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.openParenToken = oldNode.openParenToken();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public NilTypeDescriptorNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public NilTypeDescriptorNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public NilTypeDescriptorNode apply() {
            return this.oldNode.modify(this.openParenToken, this.closeParenToken);
        }
    }
}

