/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class OnFailClauseNode
extends ClauseNode {
    public OnFailClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token onKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token failKeyword() {
        return (Token)this.childInBucket(1);
    }

    public TypeDescriptorNode typeDescriptor() {
        return (TypeDescriptorNode)this.childInBucket(2);
    }

    public IdentifierToken failErrorName() {
        return (IdentifierToken)this.childInBucket(3);
    }

    public BlockStatementNode blockStatement() {
        return (BlockStatementNode)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"onKeyword", "failKeyword", "typeDescriptor", "failErrorName", "blockStatement"};
    }

    public OnFailClauseNode modify(Token onKeyword, Token failKeyword, TypeDescriptorNode typeDescriptor, IdentifierToken failErrorName, BlockStatementNode blockStatement) {
        if (this.checkForReferenceEquality(onKeyword, failKeyword, typeDescriptor, failErrorName, blockStatement)) {
            return this;
        }
        return NodeFactory.createOnFailClauseNode(onKeyword, failKeyword, typeDescriptor, failErrorName, blockStatement);
    }

    public OnFailClauseNodeModifier modify() {
        return new OnFailClauseNodeModifier(this);
    }

    public static class OnFailClauseNodeModifier {
        private final OnFailClauseNode oldNode;
        private Token onKeyword;
        private Token failKeyword;
        private TypeDescriptorNode typeDescriptor;
        private IdentifierToken failErrorName;
        private BlockStatementNode blockStatement;

        public OnFailClauseNodeModifier(OnFailClauseNode oldNode) {
            this.oldNode = oldNode;
            this.onKeyword = oldNode.onKeyword();
            this.failKeyword = oldNode.failKeyword();
            this.typeDescriptor = oldNode.typeDescriptor();
            this.failErrorName = oldNode.failErrorName();
            this.blockStatement = oldNode.blockStatement();
        }

        public OnFailClauseNodeModifier withOnKeyword(Token onKeyword) {
            Objects.requireNonNull(onKeyword, "onKeyword must not be null");
            this.onKeyword = onKeyword;
            return this;
        }

        public OnFailClauseNodeModifier withFailKeyword(Token failKeyword) {
            Objects.requireNonNull(failKeyword, "failKeyword must not be null");
            this.failKeyword = failKeyword;
            return this;
        }

        public OnFailClauseNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public OnFailClauseNodeModifier withFailErrorName(IdentifierToken failErrorName) {
            Objects.requireNonNull(failErrorName, "failErrorName must not be null");
            this.failErrorName = failErrorName;
            return this;
        }

        public OnFailClauseNodeModifier withBlockStatement(BlockStatementNode blockStatement) {
            Objects.requireNonNull(blockStatement, "blockStatement must not be null");
            this.blockStatement = blockStatement;
            return this;
        }

        public OnFailClauseNode apply() {
            return this.oldNode.modify(this.onKeyword, this.failKeyword, this.typeDescriptor, this.failErrorName, this.blockStatement);
        }
    }
}

