/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class OptionalFieldAccessExpressionNode
extends ExpressionNode {
    public OptionalFieldAccessExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token optionalChainingToken() {
        return (Token)this.childInBucket(1);
    }

    public NameReferenceNode fieldName() {
        return (NameReferenceNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "optionalChainingToken", "fieldName"};
    }

    public OptionalFieldAccessExpressionNode modify(ExpressionNode expression, Token optionalChainingToken, NameReferenceNode fieldName) {
        if (this.checkForReferenceEquality(expression, optionalChainingToken, fieldName)) {
            return this;
        }
        return NodeFactory.createOptionalFieldAccessExpressionNode(expression, optionalChainingToken, fieldName);
    }

    public OptionalFieldAccessExpressionNodeModifier modify() {
        return new OptionalFieldAccessExpressionNodeModifier(this);
    }

    public static class OptionalFieldAccessExpressionNodeModifier {
        private final OptionalFieldAccessExpressionNode oldNode;
        private ExpressionNode expression;
        private Token optionalChainingToken;
        private NameReferenceNode fieldName;

        public OptionalFieldAccessExpressionNodeModifier(OptionalFieldAccessExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.optionalChainingToken = oldNode.optionalChainingToken();
            this.fieldName = oldNode.fieldName();
        }

        public OptionalFieldAccessExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public OptionalFieldAccessExpressionNodeModifier withOptionalChainingToken(Token optionalChainingToken) {
            Objects.requireNonNull(optionalChainingToken, "optionalChainingToken must not be null");
            this.optionalChainingToken = optionalChainingToken;
            return this;
        }

        public OptionalFieldAccessExpressionNodeModifier withFieldName(NameReferenceNode fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public OptionalFieldAccessExpressionNode apply() {
            return this.oldNode.modify(this.expression, this.optionalChainingToken, this.fieldName);
        }
    }
}

